""" assumes there exist on-and-off axis FBF dirs with corresponding rolled off spectra
(such as generated by preparecube.py) and creates a new FBF dir which is ready to be
processed by the runCubeResampleTest script. Call from the parent directory of all relevant
FBF directories

Maciek Smuga-Otto (SSEC)
"""

from glob import glob
from os import mkdir, symlink, path, chdir
from sys import exit, argv
from FBF import FBF # used only to extract filename-based information

CVS_ID = "$Id: prepareResampleTestFBF.py,v 1.2 2004/06/21 16:43:58 maciek Exp $"
COPYRIGHT="Copyright 2004 University of Wisconsin - Madison"

def vectoralias( srcdir, src, destdir, dest ):
    """ links srcdir/src.typeN[.AAA].XXX.YYY to destdir/dest.typeN[.AAA]"""
    s = glob( path.join( srcdir, src + '*' ) )[0]
    stype = FBF( s ).type
    recordsize = FBF( s ).grouping[0]

    chdir( destdir )
    s = path.join( '..', s )
    d = '%s.%s.%s' % (dest, stype, recordsize)
    if len( FBF( s ).grouping ) == 2:
        d = '%s.%s' % (dest, stype)
    symlink( s, d )
    chdir( '..' )

 
def genTestDir( cubeid, detector, ignoreOffAxis = None ):
    #FIXME - no metadata generation yet!
    dirname = cubeid + '_' + detector
    specsizetab = { 'LW': 1025, 'SMW': 2049 }
    specsize = specsizetab[ detector ]

    ondirname = dirname + "_on"
    offdirname = dirname + "_off"
    if not glob( ondirname ) or (not ignoreOffAxis and not glob( offdirname )):
      if not glob( ondirname ):
        print "ensure source directory is present and target isn't"
        return
    else:
      if not glob( ondirname ) or not glob( offdirname ) or glob( dirname ):
        
        print "ensure source directories are present, and target isn't"
        return
    mkdir( dirname )

    va = lambda srcdir, src, dest: vectoralias( srcdir, src, dirname, dest )
    va( ondirname, 'wn', 'wnTruth' )
    va( ondirname, 'signalRealRolled', 'spectrumTruthRolled' )
    if not ignoreOffAxis:
      va( offdirname, 'signalRealRolled', 'spectrumOffAxisRolled' )
      va( offdirname, 'wnRatio', 'wnRatio' )


if __name__ == '__main__':
  if len( argv ) != 3:
    print "usage: %s cubename detector" % argv[0]
    exit( 1 )
  genTestDir( argv[1], argv[2] )


