/**
* \file PlanckTest.cc
 * Unit tests for the Planck curve utility library
 *
 * \author Maciek Smuga-Otto <maciek@ssec.wisc.edu>
 *
 * \version $Id: PlanckTest.cc,v 1.3.2.3 2005/12/15 23:13:34 rayg Exp $
 *
 *  \par Copyright:
 *  \verbatim
 *
 *  Copyright UW/SSEC, ALL RIGHTS RESERVED, 2005
 *  Space Science and Engineering Center
 *  University of Wisconsin - Madison, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  \endverbatim
 */

#include <iostream>
#include <vector>
#include "Planck.hxx"

using namespace std;
using namespace gips;

int main()
{
    const int SIZE = 500;
    const int OFFSET = 400;
    const int TEMP = 270;
    
    std::vector<double> arwen(SIZE);
    for(int i = 0; i < SIZE; ++i)
        arwen[i] = i + OFFSET;
    
    PlanckRadiances< std::vector<double> > ton(TEMP,&arwen);
    double x( ton[SIZE/2] );
    x += 0.0;
    
    //for( int i=0; i < SIZE; ++i )
    //{
    //    assert( ton[i] == rad(i) );
    //}
    
    // cout <<  rad << endl;
    return 0;
}
