/*
 * \file CplxFFTTest.cc
 * \brief unit test for CplxFFT operator
 * \author Maciek Smuga-Otto <maciek@ssec.wisc.edu>
 *
 *  \version $Id: CplxFFTTest.cc,v 1.19 2005/12/08 22:21:51 rayg Exp $
 *
 *  \par Copyright:
 *  \verbatim
 *
 *  Copyright UW/SSEC, ALL RIGHTS RESERVED, 2004
 *  Space Science and Engineering Center
 *  University of Wisconsin - Madison, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  \endverbatim
 */

#include <complex>

#include "CplxFFT.hxx"

using namespace gips;
using std::complex;


const unsigned SIZE = 16384;

typedef std::vector< std::complex<float> > vfloat;
typedef CplxFFT<vfloat,vfloat> MyCplxFFT;

void livenessTest( )
{
    vfloat input(SIZE,1.0), output(SIZE,0.0);
    MyCplxFFT::settings_t settings = { SIZE };
        
    // invoke operator with the correct ports
    MyCplxFFT::Ports ports(&input, &output);

    MyCplxFFT op(settings,ports);
    int res = op();
    
    assert(res == 0);
}; // testOperator()

int main()
{
    livenessTest();
    return(0);
}

