/*
 * \file IfgShiftTest.cc
 * \brief unit test for IfgShift operator
 * \author Maciek Smuga-Otto <maciek@ssec.wisc.edu>
 *
 *  \version $Id: IfgShiftTest.cc,v 1.20.2.1 2005/12/15 20:58:26 rayg Exp $
 *
 *  \par Copyright:
 *  \verbatim
 *
 *  Copyright UW/SSEC, ALL RIGHTS RESERVED, 2004
 *  Space Science and Engineering Center
 *  University of Wisconsin - Madison, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  \endverbatim
 */


#include <iostream> // std::cerr
#include <complex>

#include "IfgShift.hxx"

using namespace gips;
using std::complex;

typedef std::vector< std::complex< float > > vfloat;

typedef IfgShift< vfloat, vfloat > MyIfgShift;

const unsigned SIZE = 8192;

void livenessTest()
{
    MyIfgShift::settings_t settings = { SIZE };
    vfloat in(SIZE,1.0), out(SIZE,0.0);
    
    MyIfgShift::Ports init_ports( &in, &out );
    
    MyIfgShift op( settings, init_ports );
    int res = op();
    assert( 0==res );
}; // testOperator()


int main()
{
    livenessTest();
    return(0);
}

