/*
 * \brief SHIS implementation of Ifg2SpectrumStage
 * \author Maciek Smuga-Otto <maciek@ssec.wisc.edu>
 *
 * based directly on the Scanning-HIS rsh2fbf application, written by Ray Garcia <rayg@ssec.wisc.edu>
 *
 *  \version $Id: IfgToSpectrum.hxx,v 1.1.2.4 2005/12/14 23:35:51 rayg Exp $
 *
 *  \par Copyright:
 *  \verbatim
 *
 *  Copyright UW/SSEC, ALL RIGHTS RESERVED, 2004
 *  Space Science and Engineering Center
 *  University of Wisconsin - Madison, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  \endverbatim
 */

// NOTE: THIS FILE WILL BE AUTO-GENERATED IN THE FUTURE FROM INTEFACE DESCRIPTIONS
// OF THE SUBCAPSULES BY MEANS OF A FLANGING COMPILER

#include <complex>
#include <vector>

#include <boost/shared_ptr.hpp>

#include "IfgShift.hxx"
#include "CplxFFT.hxx"
#include "SpectrumChop.hxx"

namespace gips {

template
<
    typename InType,
    typename OutType 
>
class IfgToSpectrum
{
    // internal sub-capsule types
    typedef std::vector< std::complex< double > > buffer; // internal buffer type
    
    typedef IfgShift<InType,buffer> MyIfgShift;
    typedef CplxFFT<buffer,buffer> MyCplxFFT;
    typedef SpectrumChop<buffer,OutType> MySpectrumChop;
    
public:
    struct settings_t 
    {
        unsigned int interferogramSize; // number of points in raw interferogram

        unsigned int chopRawSpectrumFrom;  
        unsigned int chopRawSpectrumTo;
        bool wrapRawSpectrumLastPoint;

        template< typename Src > 
        static settings_t fromStruct( const Src &x )
        {
            settings_t ret;
            ret.interferogramSize = x.interferogramSize;
            ret.chopRawSpectrumFrom = x.chopRawSpectrumFrom;
            ret.chopRawSpectrumTo = x.chopRawSpectrumTo;
            ret.wrapRawSpectrumLastPoint = x.wrapRawSpectrumLastPoint;
            return ret;
        }
    };
    
    struct Ports 
    {
        const InType *obs_in;
        OutType *obs_out;
                
        Ports(const InType *obs_in_,
              OutType *obs_out_):   
           obs_in(obs_in_), obs_out(obs_out_)
        {
        }
    };

protected:
    settings_t settings;
    Ports P;
    
    buffer is2cf;
    buffer cf2sc;

    MyIfgShift capsule1;
    MyCplxFFT capsule2;
    MySpectrumChop capsule3;
    
    typename MyIfgShift::settings_t _isSettings()
    {
        return MyIfgShift::settings_t::fromStruct( settings );
    }

    typename MyCplxFFT::settings_t _cfSettings()
    {
        return MyCplxFFT::settings_t::fromStruct( settings );
    }
    
    typename MySpectrumChop::settings_t _scSettings()
    {
        return MySpectrumChop::settings_t::fromStruct(settings);
    }
        
public:
    explicit IfgToSpectrum( const settings_t &settings_, const Ports &ports ): settings(settings_), P(ports),
        // initialize buffer to proper sizes
        is2cf(settings_.interferogramSize),
        cf2sc(settings_.interferogramSize),
        // initialize sub-capsules to move data between capsule input and output
        capsule1( _isSettings(), MyIfgShift::Ports(ports.obs_in,&is2cf) ), 
        capsule2( _cfSettings(), MyCplxFFT::Ports(&is2cf,&cf2sc) ), 
        capsule3( _scSettings(), MySpectrumChop::Ports(&cf2sc,ports.obs_out) )
    {
    }  
    
    int operator() ( )
    {   
        int res1, res2, res3;
        //std::cerr << "C++: in Cifg2Spectrum::operator()" << std::endl; // DEBUG
        res1 = capsule1();
        //std::cerr << "buffer_1@600: " << buffer_1.shiftedInterferogram[600] << std::endl; // DEBUG
        res2 = capsule2();
        //std::cerr << "buffer_2@600: " << buffer_2.doubledRawSpectrum[600] << std::endl; // DEBUG
        res3 = capsule3();
        //std::cerr << "Cifg2Spectrum:" << res1 << res2 << res3 << std::endl; // DEBUG
        return (res1==0 && res2==0 && res3==0)? 0 : -1;
    }
    
}; // class
    
} // Namespace
