/*
 * \file SpectrumChopTest.cc
 * \brief unit test for SpectrumChop operator
 * \author Maciek Smuga-Otto <maciek@ssec.wisc.edu>
 *
 *  \version $Id: SpectrumChopTest.cc,v 1.8 2005/12/08 22:21:51 rayg Exp $
 *
 *  \par Copyright:
 *  \verbatim
 *
 *  Copyright UW/SSEC, ALL RIGHTS RESERVED, 2004
 *  Space Science and Engineering Center
 *  University of Wisconsin - Madison, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  \endverbatim
 */


#include <iostream>
#include <complex>

#include "SpectrumChop.hxx"

using namespace gips;
using namespace std;


void livenessTest()
{
  BasicSpectrumChop::settings_t settings;

  settings.chopRawSpectrumFrom = 1024;
  settings.chopRawSpectrumTo = 2048;
  settings.wrapRawSpectrumLastPoint = false;

  vector< complex<double> > obs_in(2048);
  vector< complex<double> > obs_out(2048);

  BasicSpectrumChop::Ports ports(&obs_in, &obs_out);
  
  BasicSpectrumChop proto( settings, ports );
  
  int res = proto();
  assert(res == 0);
};


int main()
{
  livenessTest();
  return 0;
}
