/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class AniCanvas
extends Canvas {
    Image[] baseImages = null;
    Image[][] portalImages;
    Image[][] overlayImages;
    Image fimg;
    Image offscreen;
    Graphics grOff = null;
    Graphics[] gr = null;
    int[] portalHeight;
    int[] portalWidth;
    int[] portalX;
    int[] portalY;
    int[] overlayX;
    int[] overlayY;
    int[] imageWidth;
    int[] imageHeight;
    int baseWidth;
    int baseHeight;
    int xMouse = 0;
    int yMouse = 0;
    int xDragStart = 0;
    int yDragStart = 0;
    boolean hasPortals = false;
    boolean hasOverlays = false;
    boolean hasImages = false;
    boolean forceImage = false;
    boolean dragging = false;
    boolean blank_screen = false;
    Color background;
    int currentFrame = -1;
    int numOverlays = 0;
    int numPortals = 0;
    Checkbox[] overlay = null;
    boolean doWaitMessage = false;
    String waitMessage;
    String forcedMessage;
    AniS parent = null;
    int pcount = 0;
    int z_width;
    int z_height;
    int z_xoff;
    int z_yoff;
    int z_xend;
    int z_yend;
    int zoomFactor;
    int xOffset;
    int yOffset;
    boolean isZoomed;
    boolean canZoom;
    boolean roamStop;
    Dimension dim;

    public AniCanvas(AniS aniS, boolean bl, Color color, boolean bl2) {
        this.blank_screen = bl;
        this.background = color;
        this.canZoom = false;
        this.roamStop = bl2;
        this.resetZoom();
        this.baseWidth = -1;
        this.baseHeight = -1;
        this.parent = aniS;
    }

    public boolean getZoomState() {
        return this.isZoomed;
    }

    public void setCanZoom(boolean bl) {
        this.canZoom = bl;
    }

    public void resetZoom() {
        this.zoomFactor = 1;
        this.xOffset = 0;
        this.yOffset = 0;
        this.isZoomed = false;
        this.z_xoff = 0;
        this.z_yoff = 0;
        this.z_xend = this.baseWidth;
        this.z_yend = this.baseHeight;
        if (this.parent != null) {
            this.parent.setUnzoomed();
        }
    }

    public void setPortals(Image[][] imageArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.portalImages = imageArray;
        this.portalHeight = nArray2;
        this.portalWidth = nArray;
        this.portalX = nArray3;
        this.portalY = nArray4;
        this.numPortals = this.portalImages.length;
        this.hasPortals = true;
        this.gr = null;
        this.repaint();
    }

    public void pleaseWaitMessage(String string) {
        this.waitMessage = string;
        this.doWaitMessage = true;
        this.repaint();
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.z_width = n;
        this.z_height = n2;
    }

    public void setCurrentFrame(int n) {
        this.currentFrame = n;
        this.paint(this.getGraphics());
    }

    public void setForcedImage(Image image, String string) {
        this.fimg = image;
        this.forcedMessage = string;
        this.forceImage = true;
        this.repaint();
    }

    public synchronized void setBaseImages(Image[] imageArray, int n, int n2) {
        this.hasImages = false;
        this.doWaitMessage = false;
        if (this.offscreen != null) {
            this.offscreen.flush();
        }
        if (this.grOff != null) {
            this.grOff.dispose();
        }
        if (this.baseWidth < 0 || this.baseHeight < 0) {
            this.baseWidth = n;
            this.baseHeight = n2;
            this.resetZoom();
        }
        if (this.xMouse == 0) {
            this.xMouse = this.baseWidth / 2;
            this.yMouse = this.baseHeight / 2;
        }
        this.dim = this.size();
        this.offscreen = this.createImage(this.dim.width, this.dim.height);
        this.grOff = this.offscreen.getGraphics();
        if (this.gr != null) {
            int n3 = 0;
            while (n3 < this.gr.length) {
                this.gr[n3].dispose();
                ++n3;
            }
        }
        this.gr = null;
        this.baseImages = imageArray;
        this.hasImages = true;
        this.paint(this.getGraphics());
    }

    public void setOverlays(Image[][] imageArray, Checkbox[] checkboxArray, int[] nArray, int[] nArray2) {
        this.overlayImages = imageArray;
        this.overlay = checkboxArray;
        this.numOverlays = checkboxArray.length;
        this.hasOverlays = true;
        this.doWaitMessage = false;
        this.overlayX = nArray;
        this.overlayY = nArray2;
    }

    public void setOverlayImages(Image[][] imageArray) {
        this.overlayImages = imageArray;
        this.repaint();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.xDragStart = n;
        this.yDragStart = n2;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        if (!(this.dragging || Math.abs(this.xDragStart - this.xMouse) <= 2 && Math.abs(this.yDragStart - this.yMouse) <= 2)) {
            this.dragging = true;
        }
        if (this.hasPortals) {
            this.repaint();
        } else if (this.canZoom && this.isZoomed) {
            this.xOffset = (n - this.xDragStart) * this.baseWidth / this.zoomFactor / this.dim.width;
            this.yOffset = (n2 - this.yDragStart) * this.baseHeight / this.zoomFactor / this.dim.height;
            if (this.roamStop) {
                if (this.xOffset > this.z_xoff) {
                    this.xOffset = this.z_xoff;
                }
                if (this.yOffset > this.z_yoff) {
                    this.yOffset = this.z_yoff;
                }
                if (this.z_xend - this.xOffset > this.baseWidth) {
                    this.xOffset = this.z_xend - this.baseWidth;
                }
                if (this.z_yend - this.yOffset > this.baseHeight) {
                    this.yOffset = this.z_yend - this.baseHeight;
                }
            }
            this.paint(this.getGraphics());
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        if (this.dragging) {
            this.z_xoff -= this.xOffset;
            this.z_yoff -= this.yOffset;
            this.z_xend -= this.xOffset;
            this.z_yend -= this.yOffset;
            this.xOffset = 0;
            this.yOffset = 0;
            this.dragging = false;
            this.paint(this.getGraphics());
            return true;
        }
        if (this.canZoom) {
            if ((event.modifiers & 4) == 4) {
                if (this.zoomFactor <= 2) {
                    this.resetZoom();
                    this.repaint();
                    return true;
                }
                this.z_xoff = this.z_xoff - n * this.baseWidth / (this.zoomFactor - 1) / this.dim.width + n * this.baseWidth / this.zoomFactor / this.dim.width;
                this.z_yoff = this.z_yoff - n2 * this.baseHeight / (this.zoomFactor - 1) / this.dim.height + n2 * this.baseHeight / this.zoomFactor / this.dim.height;
                --this.zoomFactor;
            } else {
                ++this.zoomFactor;
                this.z_xoff = this.z_xoff + n * this.baseWidth / (this.zoomFactor - 1) / this.dim.width - n * this.baseWidth / this.zoomFactor / this.dim.width;
                this.z_yoff = this.z_yoff + n2 * this.baseHeight / (this.zoomFactor - 1) / this.dim.height - n2 * this.baseHeight / this.zoomFactor / this.dim.height;
            }
            this.z_xend = this.z_xoff + this.baseWidth / this.zoomFactor;
            this.z_yend = this.z_yoff + this.baseHeight / this.zoomFactor;
            this.isZoomed = true;
            if (this.roamStop) {
                if (this.xOffset > this.z_xoff) {
                    this.xOffset = this.z_xoff;
                }
                if (this.yOffset > this.z_yoff) {
                    this.yOffset = this.z_yoff;
                }
                if (this.z_xend - this.xOffset > this.baseWidth) {
                    this.xOffset = this.z_xend - this.baseWidth;
                }
                if (this.z_yend - this.yOffset > this.baseHeight) {
                    this.yOffset = this.z_yend - this.baseHeight;
                }
            }
        }
        this.dragging = false;
        this.repaint();
        return true;
    }

    void paintMyMessage(Graphics graphics, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string);
        Dimension dimension = this.size();
        graphics.setColor(Color.black);
        graphics.fillRect(dimension.width / 2 - n2 / 2 - 10, dimension.height / 2 - n / 2 - 5, n2 + 20, n + 10);
        graphics.setColor(Color.white);
        graphics.drawString(string, dimension.width / 2 - n2 / 2, dimension.height / 2 + n / 2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        ++this.pcount;
        if (graphics == null) {
            return;
        }
        if (this.forceImage) {
            if (this.fimg != null) {
                graphics.drawImage(this.fimg, 0, 0, this);
            }
            this.forceImage = false;
            this.paintMyMessage(graphics, this.forcedMessage);
            if (!this.doWaitMessage) {
                return;
            }
        }
        if (this.doWaitMessage) {
            this.paintMyMessage(graphics, this.waitMessage);
            return;
        }
        if (!this.hasImages) {
            this.paintMyMessage(graphics, "No images yet");
        } else if (this.currentFrame >= 0) {
            int n;
            if (this.blank_screen) {
                this.grOff.setColor(this.background);
                this.grOff.fillRect(0, 0, this.dim.width, this.dim.height);
            }
            if (this.baseImages[this.currentFrame] != null) {
                this.grOff.setColor(this.background);
                this.grOff.fillRect(0, 0, this.dim.width, this.dim.height);
                this.grOff.drawImage(this.baseImages[this.currentFrame], 0, 0, this.z_width, this.z_height, this.z_xoff - this.xOffset, this.z_yoff - this.yOffset, this.z_xend - this.xOffset, this.z_yend - this.yOffset, this);
            }
            if (this.hasOverlays) {
                n = 0;
                while (n < this.numOverlays) {
                    if (this.overlay[n].getState() && this.overlayImages[n][this.currentFrame] != null) {
                        if (this.overlayX == null) {
                            this.grOff.drawImage(this.overlayImages[n][this.currentFrame], 0, 0, this.z_width, this.z_height, this.z_xoff - this.xOffset, this.z_yoff - this.yOffset, this.z_xend - this.xOffset, this.z_yend - this.yOffset, this);
                        } else {
                            this.grOff.drawImage(this.overlayImages[n][this.currentFrame], this.overlayX[n], this.overlayY[n], this.z_width - this.overlayX[n], this.z_height - this.overlayY[n], this.z_xoff, this.z_yoff, this.z_xend, this.z_yend, this);
                        }
                    }
                    ++n;
                }
            }
            if (this.hasPortals) {
                if (this.gr == null) {
                    this.gr = new Graphics[this.numPortals];
                    this.imageWidth = new int[this.numPortals];
                    this.imageHeight = new int[this.numPortals];
                    n = 0;
                    while (n < this.numPortals) {
                        this.gr[n] = this.grOff.create(this.portalX[n], this.portalY[n], this.portalWidth[n], this.portalHeight[n]);
                        this.imageWidth[n] = this.portalImages[n][0].getWidth(this.parent);
                        this.imageHeight[n] = this.portalImages[n][0].getHeight(this.parent);
                        ++n;
                    }
                }
                n = 0;
                while (n < this.numPortals) {
                    int n2;
                    int n3;
                    this.gr[n].setColor(Color.black);
                    this.gr[n].fillRect(0, 0, this.portalWidth[n], this.portalHeight[n]);
                    if (this.isZoomed) {
                        n3 = this.z_xoff + this.xMouse / this.zoomFactor - this.portalWidth[n] / 2 * this.imageWidth[n] / this.zoomFactor / this.baseWidth;
                        n2 = this.z_yoff + this.yMouse / this.zoomFactor - this.portalHeight[n] / 2 * this.imageHeight[n] / this.zoomFactor / this.baseHeight;
                        int n4 = 0;
                        int n5 = 0;
                        if (n3 < 0) {
                            n4 = -n3;
                            n3 = 0;
                        }
                        if (n2 < 0) {
                            n5 = -n2;
                            n2 = 0;
                        }
                        this.gr[n].drawImage(this.portalImages[n][this.currentFrame], n4, n5, this.portalWidth[n], this.portalHeight[n], n3, n2, n3 + (this.portalWidth[n] - n4) / this.zoomFactor, n2 + (this.portalHeight[n] - n5) / this.zoomFactor, this);
                    } else {
                        n3 = -this.xMouse * 100 * this.imageWidth[n] / this.baseWidth / 100 + this.portalWidth[n] / 2;
                        n2 = -this.yMouse * 100 * this.imageHeight[n] / this.baseHeight / 100 + this.portalHeight[n] / 2;
                        this.gr[n].drawImage(this.portalImages[n][this.currentFrame], n3, n2, this);
                    }
                    this.gr[n].setColor(Color.black);
                    this.gr[n].drawRect(0, 0, this.portalWidth[n] - 1, this.portalHeight[n] - 1);
                    this.gr[n].drawRect(this.portalWidth[n] / 2 - 3, this.portalHeight[n] / 2 - 3, 7, 7);
                    this.gr[n].setColor(Color.white);
                    this.gr[n].drawRect(this.portalWidth[n] / 2 - 2, this.portalHeight[n] / 2 - 2, 5, 5);
                    ++n;
                }
                this.grOff.setColor(Color.white);
                this.grOff.drawRect(this.xMouse - 3, this.yMouse - 3, 7, 7);
                this.grOff.setColor(Color.black);
                this.grOff.drawRect(this.xMouse - 2, this.yMouse - 2, 5, 5);
            }
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
    }
}

