/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Contrast
extends Applet
implements AdjustmentListener,
ItemListener {
    Scrollbar leftScroll;
    Scrollbar rightScroll;
    Scrollbar bottomScroll;
    ColorPicker leftPicker;
    ColorPicker rightPicker;
    ColorPicker bottomPicker;
    Font fn;
    Font fs;
    boolean doCheckers;
    Checkbox checkered;
    int checkerWidth = 1;

    public void init() {
        this.setLayout(null);
        this.doCheckers = false;
        boolean bl = false;
        String string = this.getParameter("checkerboard");
        if (string != null) {
            bl = true;
            this.checkerWidth = Integer.parseInt(string);
        }
        this.setBackground(Color.white);
        this.fn = new Font("sans", 1, 48);
        this.fs = new Font("sans", 0, 12);
        this.leftScroll = new Scrollbar(1, 15, 1, 0, 101);
        this.rightScroll = new Scrollbar(1, 85, 1, 0, 101);
        this.bottomScroll = new Scrollbar(0, 50, 1, 0, 101);
        this.leftPicker = new ColorPicker(1, 25, 75, 15, 0, this);
        this.rightPicker = new ColorPicker(1, 360, 75, 15, 0, this);
        this.bottomPicker = new ColorPicker(0, 145, 270, 15, 0, this);
        this.checkered = new Checkbox("Checkerboard");
        this.checkered.setBounds(150, 5, 100, 20);
        if (bl) {
            this.checkered.addItemListener(this);
            this.add(this.checkered);
        }
        this.leftScroll.setBounds(60, 30, 15, 200);
        this.rightScroll.setBounds(325, 30, 15, 200);
        this.bottomScroll.setBounds(100, 245, 200, 15);
        this.add(this.leftScroll);
        this.add(this.rightScroll);
        this.add(this.bottomScroll);
        this.add(this.leftPicker);
        this.add(this.rightPicker);
        this.add(this.bottomPicker);
        this.leftScroll.addAdjustmentListener(this);
        this.rightScroll.addAdjustmentListener(this);
        this.bottomScroll.addAdjustmentListener(this);
        this.validate();
        this.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(Color.black);
        graphics.setFont(this.fs);
        graphics.drawString("Left Background", 2, 20);
        graphics.drawString("Right Background", 305, 20);
        graphics.drawString("Foreground", 163, 300);
        this.doCheckers = this.checkered.getState();
        Image image = this.createImage(200, 200);
        Graphics graphics2 = image.getGraphics();
        Color color = this.leftPicker.getSelectedColor();
        int n3 = color.getRed() * this.leftScroll.getValue() / 100;
        int n4 = color.getGreen() * this.leftScroll.getValue() / 100;
        int n5 = color.getBlue() * this.leftScroll.getValue() / 100;
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        Color color2 = new Color(n3, n4, n5);
        graphics2.setColor(color2);
        if (this.doCheckers) {
            for (int i = 0; i < 100 / this.checkerWidth; i += 2) {
                for (n2 = 0; n2 < 200 / this.checkerWidth; ++n2) {
                    graphics2.fillRect(this.checkerWidth * i + this.checkerWidth * (n2 % 2), this.checkerWidth * n2, this.checkerWidth, this.checkerWidth);
                }
            }
        } else {
            graphics2.fillRect(0, 0, 100, 200);
        }
        color = this.rightPicker.getSelectedColor();
        n3 = color.getRed() * this.rightScroll.getValue() / 100;
        n4 = color.getGreen() * this.rightScroll.getValue() / 100;
        n5 = color.getBlue() * this.rightScroll.getValue() / 100;
        Color color3 = new Color(n3, n4, n5);
        graphics2.setColor(color3);
        if (this.doCheckers) {
            for (n2 = 0; n2 < 100 / this.checkerWidth; n2 += 2) {
                for (n = 0; n < 200 / this.checkerWidth; ++n) {
                    graphics2.fillRect(100 + this.checkerWidth * n2 + this.checkerWidth * (n % 2), this.checkerWidth * n, this.checkerWidth, this.checkerWidth);
                }
            }
        } else {
            graphics2.fillRect(100, 0, 100, 200);
        }
        color = this.bottomPicker.getSelectedColor();
        n3 = color.getRed() * this.bottomScroll.getValue() / 100;
        n4 = color.getGreen() * this.bottomScroll.getValue() / 100;
        n5 = color.getBlue() * this.bottomScroll.getValue() / 100;
        graphics2.setColor(new Color(n3, n4, n5));
        graphics2.fillRect(25, 70, 50, 50);
        graphics2.fillRect(125, 70, 50, 50);
        graphics2.setFont(this.fn);
        graphics2.drawString("abcdefg", 2, 185);
        if (this.doCheckers) {
            for (n2 = 0; n2 < 100 / this.checkerWidth; n2 += 2) {
                for (n = 0; n < 200 / this.checkerWidth; ++n) {
                    graphics2.setColor(color3);
                    graphics2.fillRect(this.checkerWidth * n2 + this.checkerWidth * (1 - n % 2), this.checkerWidth * n, this.checkerWidth, this.checkerWidth);
                    graphics2.setColor(color2);
                    graphics2.fillRect(100 + this.checkerWidth * n2 + this.checkerWidth * (1 - n % 2), this.checkerWidth * n, this.checkerWidth, this.checkerWidth);
                }
            }
        }
        graphics.drawImage(image, 100, 30, null);
        image.flush();
        graphics2.dispose();
        graphics.dispose();
    }

    class ColorPicker
    extends Canvas
    implements MouseListener {
        int x0;
        int y0;
        int width;
        int height;
        int horver;
        int selected;
        int numColors;
        int xinc;
        int yinc;
        int size;
        Contrast mom;
        Color[] colors = new Color[]{Color.lightGray, Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};

        public ColorPicker(int n, int n2, int n3, int n4, int n5, Contrast contrast2) {
            this.horver = n;
            this.x0 = n2;
            this.y0 = n3;
            this.selected = n5;
            this.size = n4;
            this.mom = contrast2;
            this.numColors = this.colors.length;
            if (this.horver == 0) {
                this.xinc = this.size;
                this.yinc = 0;
                this.width = this.size * (this.numColors + 1);
                this.height = this.size;
            } else {
                this.xinc = 0;
                this.yinc = this.size;
                this.height = this.size * (this.numColors + 1);
                this.width = this.size;
            }
            this.setBounds(this.x0, this.y0, this.width, this.height);
            this.addMouseListener(this);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            for (int i = 0; i < this.numColors; ++i) {
                graphics.setColor(this.colors[i]);
                graphics.fillRect(i * this.xinc, i * this.yinc, this.size, this.size);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(this.selected * this.xinc, this.selected * this.yinc, this.size - 1, this.size - 1);
            graphics.drawRect(this.selected * this.xinc + 1, this.selected * this.yinc + 1, this.size - 3, this.size - 3);
        }

        public Color getSelectedColor() {
            if (this.selected != 0) {
                return this.colors[this.selected];
            }
            return Color.white;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.selected = this.horver == 0 ? mouseEvent.getX() / this.xinc : mouseEvent.getY() / this.yinc;
            this.repaint();
            this.mom.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

