/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TriColor
extends Applet {
    Canvas can;
    TriPanel rp;
    TriPanel gp;
    TriPanel bp;
    int xb;
    int yb;

    public void init() {
        this.setLayout(null);
        this.setBackground(Color.lightGray);
        this.setFont(new Font("sanserif", 0, 12));
        this.xb = 60;
        this.yb = 60;
        this.rp = new TriPanel(0, this.xb, this.yb, this);
        this.add(this.rp);
        this.gp = new TriPanel(1, this.xb, this.yb + 45, this);
        this.add(this.gp);
        this.bp = new TriPanel(2, this.xb, this.yb + 90, this);
        this.add(this.bp);
        this.can = new Canvas();
        this.can.setBounds(this.xb + 125, this.yb, 135, 135);
        this.add(this.can);
        this.show();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = this.can.getGraphics();
        if (graphics2 == null) {
            return;
        }
        Color color = new Color(255 * this.rp.getValue() / 100, 255 * this.gp.getValue() / 100, 255 * this.bp.getValue() / 100);
        graphics2.setColor(color);
        graphics2.fillRect(0, 0, 135, 135);
        graphics.setColor(Color.black);
        graphics.drawString("Computer", 2, 15);
        graphics.drawString("Display", 8, 30);
        graphics.drawString("Color", 14, 45);
        graphics.drawLine(2, 50, 55, 50);
        graphics.drawString("Red", 17, this.yb + 25);
        graphics.drawString("Green", 10, this.yb + 70);
        graphics.drawString("Blue", 15, this.yb + 115);
        graphics.drawString("Intensity", 80, 15);
        graphics.drawString("of", 95, 30);
        graphics.drawString("Color [%]", 80, 45);
        graphics.drawLine(75, 50, 135, 50);
    }

    class AutoIncrement
    extends Thread {
        TriPanel mom;
        int mode;
        boolean isRunning;
        int count;
        int delay;

        AutoIncrement(TriPanel triPanel, int n) {
            this.mom = triPanel;
            this.mode = n;
            this.isRunning = true;
            this.count = 0;
            this.delay = 66;
        }

        void cease() {
            this.isRunning = false;
        }

        public void run() {
            while (this.isRunning) {
                this.mom.bumpValue(this.mode);
                ++this.count;
                if (this.count > 100) {
                    this.isRunning = false;
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (Exception exception) {
                    this.isRunning = false;
                }
            }
        }
    }

    class TriButt
    extends Canvas
    implements MouseListener {
        int x0;
        int y0;
        int size;
        int mode;
        Color fill;
        Color fillIdle;
        Color fillActive;
        Polygon p;
        AutoIncrement ai;
        TriPanel mom;

        TriButt(int n, int n2, int n3, int n4, TriPanel triPanel) {
            this.x0 = n;
            this.y0 = n2;
            this.size = n3;
            this.mode = n4;
            this.mom = triPanel;
            this.ai = null;
            this.setBounds(n, n2, n3, n3);
            this.fillIdle = Color.white;
            this.fillActive = new Color(100, 100, 100);
            this.fill = this.fillIdle;
            this.addMouseListener(this);
            this.p = new Polygon();
            if (this.mode == 1) {
                this.p.addPoint(2, this.size - 2);
                this.p.addPoint(this.size / 2, 2);
                this.p.addPoint(this.size - 2, this.size - 2);
                this.p.addPoint(2, this.size - 2);
            } else {
                this.p.addPoint(2, 2);
                this.p.addPoint(this.size / 2, this.size - 2);
                this.p.addPoint(n3 - 2, 2);
                this.p.addPoint(2, 2);
            }
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.fill);
            graphics.fillRect(0, 0, this.size, this.size);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.size, this.size);
            graphics.setColor(Color.black);
            graphics.fillPolygon(this.p);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.ai != null) {
                return;
            }
            this.ai = new AutoIncrement(this.mom, this.mode);
            this.ai.start();
            this.fill = this.fillActive;
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.ai.cease();
            this.ai = null;
            this.fill = this.fillIdle;
            this.repaint();
        }
    }

    class TriPanel
    extends Panel
    implements TextListener,
    FocusListener {
        Dimension d;
        int myColor;
        TextField tf;
        TriButt up;
        TriButt down;
        int value;
        int oldvalue;
        TriColor mom;
        boolean gotFocus;
        boolean notText;
        int x0;
        int y0;

        TriPanel(int n, int n2, int n3, TriColor triColor2) {
            this.myColor = n;
            this.value = 0;
            this.mom = triColor2;
            this.x0 = n2;
            this.y0 = n3;
        }

        public void init() {
            this.setLayout(null);
            this.oldvalue = -1;
            this.gotFocus = false;
            this.notText = true;
            this.tf = new TextField(3);
            Font font = new Font("sanserif", 0, 12);
            this.tf.setFont(font);
            this.tf.setText("0");
            this.tf.setColumns(3);
            this.add(this.tf);
            this.d = this.tf.getPreferredSize();
            int n = 5;
            int n2 = 20 - this.d.height / 2;
            this.tf.setBounds(n, n2, this.d.width, this.d.height);
            this.tf.setEditable(true);
            this.tf.selectAll();
            this.tf.addTextListener(this);
            this.tf.addFocusListener(this);
            this.up = new TriButt(5 + this.d.width + 5, 2, 16, 1, this);
            this.down = new TriButt(5 + this.d.width + 5, 22, 16, -1, this);
            this.add(this.up);
            this.add(this.down);
            this.setBounds(this.x0, this.y0, this.d.width + 5 + 16 + 5 + 40, 40);
            this.repaint();
        }

        public void textValueChanged(TextEvent textEvent) {
            int n = 0;
            if (this.tf.getText().length() == 0) {
                this.value = 0;
                this.oldvalue = -1;
            } else {
                try {
                    n = Integer.parseInt(this.tf.getText());
                }
                catch (Exception exception) {
                    n = 0;
                }
                this.value = n;
                if (this.value == this.oldvalue) {
                    return;
                }
                if (this.value > 100 || this.value < 0) {
                    if (this.value > 100) {
                        this.value = 100;
                    }
                    if (this.value < 0) {
                        this.value = 0;
                    }
                    this.tf.setText(String.valueOf(this.value));
                    this.tf.setCaretPosition(this.tf.getText().length());
                }
                this.oldvalue = this.value;
            }
            this.notText = false;
            this.repaint();
        }

        public int getValue() {
            return this.value;
        }

        public void bumpValue(int n) {
            this.value += n;
            if (this.value < 0) {
                this.value = 0;
            }
            if (this.value > 100) {
                this.value = 100;
            }
            this.repaint();
        }

        public void addNotify() {
            super.addNotify();
            this.init();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.gotFocus = true;
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.gotFocus = false;
            this.tf.select(0, 0);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            this.up.repaint();
            this.down.repaint();
            if (this.myColor == 0) {
                n3 = 255 * this.value / 100;
                n2 = 0;
                n = 0;
            } else if (this.myColor == 1) {
                n3 = 0;
                n2 = 255 * this.value / 100;
                n = 0;
            } else {
                n3 = 0;
                n2 = 0;
                n = 255 * this.value / 100;
            }
            Color color = new Color(n3, n2, n);
            graphics.setColor(color);
            graphics.fillRect(5 + this.d.width + 5 + 16 + 5, 2, 38, 38);
            this.gotFocus = false;
            if (this.notText) {
                this.tf.setText(String.valueOf(this.value));
            }
            this.notText = true;
            this.mom.repaint();
        }
    }
}

