/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MixingColors
extends Applet
implements MouseListener {
    ColorCanvas[] leftColors;
    ColorCanvas[] rightColors;
    CombinedCanvas rgbCanvas;
    CombinedCanvas cmyCanvas;
    Color[] colors;
    int selectLeft;
    int selectRight;
    int x0;
    int xr;
    int xb;
    int y0;
    int canH;
    int canW;
    int cmyY0;
    int rgbY0;
    int yOff;
    int canSize;
    Image brush;
    Image lamp;
    Font f;
    Font fbold;
    FontMetrics fm;
    FontMetrics fmbold;

    public void init() {
        this.setBackground(Color.lightGray);
        this.setLayout(null);
        this.selectLeft = 0;
        this.selectRight = 5;
        this.canSize = 20;
        this.x0 = 30;
        this.xr = 350;
        this.y0 = 25;
        this.canH = 90;
        this.canW = 270;
        this.xb = this.x0 + this.canSize + 60;
        this.xr = this.xb + this.canW + 60;
        this.yOff = 60;
        this.rgbY0 = this.y0 + this.canH + 40;
        this.cmyY0 = this.y0;
        GetImageFile getImageFile = new GetImageFile(this);
        this.brush = getImageFile.getImage("brush.gif");
        this.lamp = getImageFile.getImage("bulb.gif");
        this.leftColors = new ColorCanvas[6];
        this.rightColors = new ColorCanvas[6];
        this.rgbCanvas = new CombinedCanvas(this.lamp, this.canW, this.canH);
        this.cmyCanvas = new CombinedCanvas(this.brush, this.canW, this.canH);
        this.setLayout(null);
        this.colors = new Color[6];
        this.colors[0] = new Color(255, 0, 0);
        this.colors[1] = new Color(255, 255, 0);
        this.colors[2] = new Color(0, 255, 0);
        this.colors[3] = new Color(0, 255, 255);
        this.colors[4] = new Color(0, 0, 255);
        this.colors[5] = new Color(255, 0, 255);
        for (int i = 0; i < 6; ++i) {
            this.leftColors[i] = new ColorCanvas();
            this.leftColors[i].setBounds(this.x0, this.yOff + this.y0 + (2 + this.canSize) * i, this.canSize, this.canSize);
            this.leftColors[i].addMouseListener(this);
            this.leftColors[i].setBackground(this.colors[i]);
            this.add(this.leftColors[i]);
            this.rightColors[i] = new ColorCanvas();
            this.rightColors[i].setBounds(this.xr, this.yOff + this.y0 + (2 + this.canSize) * i, this.canSize, this.canSize);
            this.rightColors[i].addMouseListener(this);
            this.rightColors[i].setBackground(this.colors[i]);
            this.add(this.rightColors[i]);
        }
        this.f = new Font("sansserif", 0, 12);
        this.fbold = new Font("sansserif", 1, 12);
        this.fm = this.getFontMetrics(this.f);
        this.fmbold = this.getFontMetrics(this.fbold);
        this.cmyCanvas.setBounds(this.xb, this.cmyY0, this.canW, this.canH);
        this.rgbCanvas.setBounds(this.xb, this.rgbY0, this.canW, this.canH);
        this.add(this.rgbCanvas);
        this.add(this.cmyCanvas);
        this.leftColors[this.selectLeft].setSelected(true);
        this.rightColors[this.selectRight].setSelected(true);
        this.refresh();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(this.fbold);
        String string = "Mixed Pigments";
        int n = this.fmbold.stringWidth(string);
        graphics.drawString(string, this.canW / 2 + this.xb - n / 2, this.cmyY0 - 5);
        string = "Mixed Light";
        n = this.fmbold.stringWidth(string);
        graphics.drawString(string, this.canW / 2 + this.xb - n / 2, this.rgbY0 - 5);
        graphics.setFont(this.f);
        int n2 = this.fm.getAscent();
        string = "Palette";
        n = this.fm.stringWidth(string);
        graphics.drawString(string, this.x0 + this.canSize / 2 - n / 2, this.yOff + this.y0 - 3 * n2);
        graphics.drawString(string, this.xr + this.canSize / 2 - n / 2, this.yOff + this.y0 - 3 * n2);
        string = "for";
        n = this.fm.stringWidth(string);
        graphics.drawString(string, this.x0 + this.canSize / 2 - n / 2, this.yOff + this.y0 - 2 * n2);
        graphics.drawString(string, this.xr + this.canSize / 2 - n / 2, this.yOff + this.y0 - 2 * n2);
        string = "Color 1";
        n = this.fm.stringWidth(string);
        graphics.drawString(string, this.x0 + this.canSize / 2 - n / 2, this.yOff + this.y0 - n2);
        string = "Color 2";
        graphics.drawString(string, this.xr + this.canSize / 2 - n / 2, this.yOff + this.y0 - n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        for (int i = 0; i < 6; ++i) {
            if (mouseEvent.getSource() == this.leftColors[i]) {
                this.selectLeft = i;
            }
            if (mouseEvent.getSource() != this.rightColors[i]) continue;
            this.selectRight = i;
        }
        this.refresh();
    }

    void refresh() {
        double d;
        if (this.selectLeft < 0 || this.selectRight < 0) {
            return;
        }
        int n = this.colors[this.selectLeft].getRed() + this.colors[this.selectRight].getRed();
        int n2 = this.colors[this.selectLeft].getGreen() + this.colors[this.selectRight].getGreen();
        int n3 = this.colors[this.selectLeft].getBlue() + this.colors[this.selectRight].getBlue();
        int n4 = Math.max(Math.max(n, n2), n3);
        if (n4 > 0) {
            n = 255 * n / n4;
            n2 = 255 * n2 / n4;
            n3 = 255 * n3 / n4;
        }
        Color color = new Color(n, n2, n3);
        double d2 = 1.0 - (double)this.colors[this.selectLeft].getRed() / 255.0;
        double d3 = 1.0 - (double)this.colors[this.selectRight].getRed() / 255.0;
        double d4 = 1.0 - (double)this.colors[this.selectLeft].getGreen() / 255.0;
        double d5 = 1.0 - (double)this.colors[this.selectRight].getGreen() / 255.0;
        double d6 = 1.0 - (double)this.colors[this.selectLeft].getBlue() / 255.0;
        double d7 = 1.0 - (double)this.colors[this.selectRight].getBlue() / 255.0;
        double d8 = this.percentWhite(d2, d4, d6);
        double d9 = this.percentWhite(d3, d5, d7);
        double d10 = (d8 + d9) / 2.0;
        double d11 = d2 + d3;
        double d12 = d4 + d5;
        double d13 = d6 + d7;
        if (d10 > 0.0) {
            d = Math.max(Math.max(d11, d12), d13);
            d = (1.0 - d10) / d;
            d11 *= d;
            d12 *= d;
            d13 *= d;
        }
        if (d11 > 1.0 || d13 > 1.0 || d12 > 1.0) {
            d = Math.max(Math.max(d11, d12), d13);
            d11 /= d;
            d12 /= d;
            d13 /= d;
        }
        int n5 = (int)(255.0 - d11 * 255.0);
        int n6 = (int)(255.0 - d12 * 255.0);
        int n7 = (int)(255.0 - d13 * 255.0);
        Color color2 = new Color(n5, n6, n7);
        for (int i = 0; i < 6; ++i) {
            this.leftColors[i].setSelected(false);
            this.rightColors[i].setSelected(false);
        }
        this.leftColors[this.selectLeft].setSelected(true);
        this.rightColors[this.selectRight].setSelected(true);
        this.rgbCanvas.setColors(this.colors[this.selectLeft], this.colors[this.selectRight], color);
        this.cmyCanvas.setColors(this.colors[this.selectLeft], this.colors[this.selectRight], color2);
    }

    double percentWhite(double d, double d2, double d3) {
        double d4 = 1.0;
        d4 = Math.max(Math.max(d, d3), d2);
        double d5 = 1.0 - d4;
        double d6 = 0.0;
        if (d == 1.0 || d2 == 1.0 || d3 == 1.0) {
            d5 = 0.0;
        } else if (d == d3 && d3 == d2) {
            d5 = 1.0 - d;
        } else if (d == 0.0 || d3 == 0.0 || d2 == 0.0) {
            if (d == 0.0) {
                d6 = Math.min(d3, d2);
                d4 = Math.max(d3, d2);
            } else if (d3 == 0.0) {
                d6 = Math.min(d, d2);
                d4 = Math.max(d, d2);
            } else if (d2 == 0.0) {
                d6 = Math.min(d, d3);
                d4 = Math.max(d, d3);
            }
            d5 = 1.0 - Math.sqrt(d6 * d6 + d4 * d4) / Math.sqrt(d6 * d6 / (d4 * d4) + 1.0);
        } else {
            d4 = Math.max(Math.max(d, d3), d2);
            d5 = 1.0 - d4;
        }
        return d5;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class CombinedCanvas
    extends Canvas {
        Image img;
        Color left;
        Color right;
        Color combined;
        int H;
        int W;
        int imgHeight;
        int imgWidth;

        public CombinedCanvas(Image image, int n, int n2) {
            this.img = image;
            this.W = n;
            this.H = n2;
            this.imgHeight = this.img.getHeight(this);
            this.imgWidth = this.img.getWidth(this);
            this.setSize(this.W, this.H);
        }

        public void setColors(Color color, Color color2, Color color3) {
            this.left = color;
            this.right = color2;
            this.combined = color3;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.left);
            graphics.fillRect(0, 0, this.W / 3, this.H);
            graphics.setColor(this.combined);
            graphics.fillRect(this.W / 3, 0, this.W / 3, this.H);
            graphics.setColor(this.right);
            graphics.fillRect(2 * this.W / 3, 0, this.W / 3, this.H);
            graphics.drawImage(this.img, this.W / 2 - this.imgWidth / 2, this.H / 2 - this.imgHeight / 2, this);
        }
    }

    class ColorCanvas
    extends Canvas {
        boolean isSelected = false;

        ColorCanvas() {
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.isSelected) {
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, 19, 19);
                graphics.drawRect(1, 1, 17, 17);
            }
        }
    }
}

