/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;

public class TriColor
extends PApplet {
    PFont myFont;
    int xb;
    int yb;
    int active;
    ColorControl redc;
    ColorControl greenc;
    ColorControl bluec;

    public void setup() {
        this.size(400, 220);
        this.background(200.0f, 200.0f, 200.0f);
        this.framerate(15.0f);
        this.yb = 50;
        this.xb = 100;
        this.active = -1;
        this.redc = new ColorControl(this.xb, this.yb, 0);
        this.greenc = new ColorControl(this.xb, this.yb + 50, 1);
        this.bluec = new ColorControl(this.xb, this.yb + 100, 2);
        PFont pFont = this.loadFont("ArialMT-12.vlw");
        this.textFont(pFont);
        this.fill(0.0f, 0.0f, 0.0f);
        int n = 10;
        this.text("Computer", 25.0f, (float)n);
        this.text("Display", 30.0f, (float)(n + 13));
        this.text("Color", 36.0f, (float)(n + 26));
        this.text("Intensity", 110.0f, (float)n);
        this.text("of", 125.0f, (float)(n + 13));
        this.text("Color [%]", 108.0f, (float)(n + 26));
        this.text("Red", 40.0f, (float)(this.yb + 24));
        this.text("Green", 35.0f, (float)(this.yb + 24 + 50));
        this.text("Blue", 38.0f, (float)(this.yb + 24 + 100));
        this.stroke(100);
        this.line(25.0f, n + 33, 80.0f, n + 33);
        this.line(105.0f, n + 33, 160.0f, n + 33);
    }

    public void makeActive() {
        if (this.active == 0) {
            this.redc.typeOK(true);
            this.greenc.typeOK(false);
            this.bluec.typeOK(false);
        } else if (this.active == 1) {
            this.redc.typeOK(false);
            this.greenc.typeOK(true);
            this.bluec.typeOK(false);
        } else if (this.active == 2) {
            this.redc.typeOK(false);
            this.greenc.typeOK(false);
            this.bluec.typeOK(true);
        }
    }

    public void keyPressed() {
        if (this.keyCode == 9) {
            ++this.active;
            if (this.active > 2) {
                this.active = 0;
            }
            this.makeActive();
            return;
        }
        if (this.active == 0) {
            this.redc.setKey(this.key);
        } else if (this.active == 1) {
            this.greenc.setKey(this.key);
        } else if (this.active == 2) {
            this.bluec.setKey(this.key);
        }
    }

    public void mousePressed() {
        if (this.redc.inside()) {
            this.active = 0;
            this.makeActive();
        } else if (this.greenc.inside()) {
            this.active = 1;
            this.makeActive();
        } else if (this.bluec.inside()) {
            this.active = 2;
            this.makeActive();
        }
    }

    public void draw() {
        this.redc.update();
        this.greenc.update();
        this.bluec.update();
        this.fill(this.redc.getIntensity() * 255 / 100, this.greenc.getIntensity() * 255 / 100, this.bluec.getIntensity() * 255 / 100);
        this.rect(this.xb + 110, this.yb - 10, 160.0f, 160.0f);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ColorControl
    extends Widget {
        int myColor;
        int myIntensity;
        int newval;
        int val;
        Butt up;
        Butt down;
        TextF tf;
        boolean okToType;

        public int getIntensity() {
            return this.val;
        }

        public void update() {
            if (this.up.inside() && TriColor.this.mousePressed) {
                ++this.val;
            }
            if (this.down.inside() && TriColor.this.mousePressed) {
                --this.val;
            }
            if (this.val < 0) {
                this.val = 0;
            }
            if (this.val > 100) {
                this.val = 100;
            }
            this.tf.setString(TriColor.str(this.val));
            this.up.update();
            this.down.update();
            this.tf.update();
            if (this.myColor == 0) {
                TriColor.this.fill(255 * this.val / 100, 0.0f, 0.0f);
            } else if (this.myColor == 1) {
                TriColor.this.fill(0.0f, 255 * this.val / 100, 0.0f);
            } else {
                TriColor.this.fill(0.0f, 0.0f, 255 * this.val / 100);
            }
            TriColor.this.rect(this.x0 + 55, this.y0 + 2, 34.0f, 34.0f);
        }

        public void typeOK(boolean bl) {
            this.okToType = bl;
            if (this.okToType) {
                this.newval = 0;
            }
            this.tf.typeOK(this.okToType);
        }

        public void setKey(int n) {
            if (!this.okToType) {
                return;
            }
            if (n == 10) {
                this.val = this.newval;
                this.newval = 0;
            } else if (n == 8) {
                this.newval /= 10;
                this.val = this.newval;
            } else {
                int n2 = n - 48;
                if (n2 >= 0 && n2 <= 9) {
                    this.newval = this.newval * 10 + (n - 48);
                }
                if (this.newval > 100) {
                    this.newval = 100;
                }
                this.val = this.newval;
            }
            this.tf.setString(TriColor.str(this.val));
        }

        private final /* synthetic */ void this() {
            this.myColor = 0;
            this.myIntensity = 0;
        }

        ColorControl(int n, int n2, int n3) {
            this.this();
            this.x0 = n;
            this.y0 = n2;
            this.h = 40;
            this.w = 70;
            this.val = 0;
            this.okToType = false;
            this.myColor = n3;
            this.tf = new TextF(this.x0 + 2, this.y0 + 12, 15, 30);
            this.up = new Butt(this.x0 + 34, this.y0 + 2, 16, 1);
            this.down = new Butt(this.x0 + 34, this.y0 + 20, 16, -1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TextF
    extends Widget {
        String sval;
        boolean okToType;

        public void setString(String string) {
            this.sval = string;
        }

        public void typeOK(boolean bl) {
            this.okToType = bl;
        }

        public void update() {
            if (this.okToType) {
                TriColor.this.fill(255.0f, 255.0f, 100.0f);
            } else {
                TriColor.this.fill(220.0f, 220.0f, 220.0f);
            }
            TriColor.this.stroke(150);
            TriColor.this.rect(this.x0, this.y0, this.w, this.h);
            TriColor.this.fill(0.0f, 0.0f, 0.0f);
            TriColor.this.text(this.sval, (float)(this.x0 + 2), (float)(this.y0 + 13));
        }

        TextF(int n, int n2, int n3, int n4) {
            this.x0 = n;
            this.y0 = n2;
            this.h = n3;
            this.w = n4;
            this.okToType = false;
            this.sval = "0";
            PFont pFont = TriColor.this.loadFont("ArialMT-12.vlw");
            TriColor.this.textFont(pFont);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Butt
    extends Widget {
        int sz;
        int md;

        public void update() {
            if (this.inside()) {
                TriColor.this.fill(255.0f, 255.0f, 100.0f);
                if (TriColor.this.mousePressed) {
                    TriColor.this.fill(100.0f, 255.0f, 255.0f);
                }
            } else {
                TriColor.this.fill(220.0f, 220.0f, 220.0f);
            }
            TriColor.this.stroke(150);
            TriColor.this.rect(this.x0, this.y0, this.w, this.h);
            TriColor.this.fill(0.0f, 0.0f, 0.0f);
            if (this.md == 1) {
                TriColor.this.triangle(this.x0 + 2, this.y0 + this.h - 2, this.x0 + this.w / 2, this.y0 + 2, this.x0 + this.w - 2, this.y0 + this.h - 2);
            } else {
                TriColor.this.triangle(this.x0 + 2, this.y0 + 2, this.x0 + this.w / 2, this.y0 + this.h - 2, this.x0 + this.w - 2, this.y0 + 2);
            }
        }

        Butt(int n, int n2, int n3, int n4) {
            this.x0 = n;
            this.y0 = n2;
            this.h = n3;
            this.w = n3;
            this.md = n4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Widget {
        int x0;
        int y0;
        int w;
        int h;

        public boolean inside() {
            if (TriColor.this.mouseX < this.x0 || TriColor.this.mouseX > this.x0 + this.w) {
                return false;
            }
            return TriColor.this.mouseY >= this.y0 && TriColor.this.mouseY <= this.y0 + this.h;
        }

        Widget() {
        }
    }
}

