/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PApplet;
import processing.core.PConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PMatrix
implements PConstants {
    static final int DEFAULT_STACK_DEPTH = 0;
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    int maxStackDepth;
    int stackPointer;
    float[][] stack;

    public final void reset() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void clearStack() {
        this.stackPointer = 0;
    }

    public final boolean push() {
        if (this.stackPointer == this.maxStackDepth) {
            return false;
        }
        this.stack[this.stackPointer][0] = this.m00;
        this.stack[this.stackPointer][1] = this.m01;
        this.stack[this.stackPointer][2] = this.m02;
        this.stack[this.stackPointer][3] = this.m03;
        this.stack[this.stackPointer][4] = this.m10;
        this.stack[this.stackPointer][5] = this.m11;
        this.stack[this.stackPointer][6] = this.m12;
        this.stack[this.stackPointer][7] = this.m13;
        this.stack[this.stackPointer][8] = this.m20;
        this.stack[this.stackPointer][9] = this.m21;
        this.stack[this.stackPointer][10] = this.m22;
        this.stack[this.stackPointer][11] = this.m23;
        this.stack[this.stackPointer][12] = this.m30;
        this.stack[this.stackPointer][13] = this.m31;
        this.stack[this.stackPointer][14] = this.m32;
        this.stack[this.stackPointer][15] = this.m33;
        ++this.stackPointer;
        return true;
    }

    public final boolean pop() {
        if (this.stackPointer == 0) {
            return false;
        }
        --this.stackPointer;
        this.m00 = this.stack[this.stackPointer][0];
        this.m01 = this.stack[this.stackPointer][1];
        this.m02 = this.stack[this.stackPointer][2];
        this.m03 = this.stack[this.stackPointer][3];
        this.m10 = this.stack[this.stackPointer][4];
        this.m11 = this.stack[this.stackPointer][5];
        this.m12 = this.stack[this.stackPointer][6];
        this.m13 = this.stack[this.stackPointer][7];
        this.m20 = this.stack[this.stackPointer][8];
        this.m21 = this.stack[this.stackPointer][9];
        this.m22 = this.stack[this.stackPointer][10];
        this.m23 = this.stack[this.stackPointer][11];
        this.m30 = this.stack[this.stackPointer][12];
        this.m31 = this.stack[this.stackPointer][13];
        this.m32 = this.stack[this.stackPointer][14];
        this.m33 = this.stack[this.stackPointer][15];
        return true;
    }

    public final void set(PMatrix pMatrix) {
        this.set(pMatrix.m00, pMatrix.m01, pMatrix.m02, pMatrix.m03, pMatrix.m10, pMatrix.m11, pMatrix.m12, pMatrix.m13, pMatrix.m20, pMatrix.m21, pMatrix.m22, pMatrix.m23, pMatrix.m30, pMatrix.m31, pMatrix.m32, pMatrix.m33);
    }

    public final void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public final void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public final void invTranslate(float f, float f2) {
        this.invTranslate(f, f2, 0.0f);
    }

    public final void translate(float f, float f2, float f3) {
        this.m03 += f * this.m00 + f2 * this.m01 + f3 * this.m02;
        this.m13 += f * this.m10 + f2 * this.m11 + f3 * this.m12;
        this.m23 += f * this.m20 + f2 * this.m21 + f3 * this.m22;
        this.m33 += f * this.m30 + f2 * this.m31 + f3 * this.m32;
    }

    public final void invTranslate(float f, float f2, float f3) {
        this.preApply(1.0f, 0.0f, 0.0f, -f, 0.0f, 1.0f, 0.0f, -f2, 0.0f, 0.0f, 1.0f, -f3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void rotateX(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invRotateX(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void rotateY(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(f2, 0.0f, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -f3, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invRotateY(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(f2, 0.0f, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -f3, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void rotate(float f) {
        this.rotateZ(f);
    }

    public final void invRotate(float f) {
        this.invRotateZ(f);
    }

    public final void rotateZ(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invRotateZ(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void rotate(float f, float f2, float f3, float f4) {
        float f5 = this.cos(f);
        float f6 = this.sin(f);
        float f7 = 1.0f - f5;
        this.apply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invRotate(float f, float f2, float f3, float f4) {
        float f5 = this.cos(-f);
        float f6 = this.sin(-f);
        float f7 = 1.0f - f5;
        this.preApply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void scale(float f) {
        this.apply(f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invScale(float f) {
        this.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void scale(float f, float f2) {
        this.apply(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invScale(float f, float f2) {
        this.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void scale(float f, float f2, float f3) {
        this.apply(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void invScale(float f, float f2, float f3) {
        this.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public final void transform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public final void preApply(PMatrix pMatrix) {
        this.preApply(pMatrix.m00, pMatrix.m01, pMatrix.m02, pMatrix.m03, pMatrix.m10, pMatrix.m11, pMatrix.m12, pMatrix.m13, pMatrix.m20, pMatrix.m21, pMatrix.m22, pMatrix.m23, pMatrix.m30, pMatrix.m31, pMatrix.m32, pMatrix.m33);
    }

    public final void preApply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        float f17 = f * this.m00 + f2 * this.m10 + f3 * this.m20 + f4 * this.m30;
        float f18 = f * this.m01 + f2 * this.m11 + f3 * this.m21 + f4 * this.m31;
        float f19 = f * this.m02 + f2 * this.m12 + f3 * this.m22 + f4 * this.m32;
        float f20 = f * this.m03 + f2 * this.m13 + f3 * this.m23 + f4 * this.m33;
        float f21 = f5 * this.m00 + f6 * this.m10 + f7 * this.m20 + f8 * this.m30;
        float f22 = f5 * this.m01 + f6 * this.m11 + f7 * this.m21 + f8 * this.m31;
        float f23 = f5 * this.m02 + f6 * this.m12 + f7 * this.m22 + f8 * this.m32;
        float f24 = f5 * this.m03 + f6 * this.m13 + f7 * this.m23 + f8 * this.m33;
        float f25 = f9 * this.m00 + f10 * this.m10 + f11 * this.m20 + f12 * this.m30;
        float f26 = f9 * this.m01 + f10 * this.m11 + f11 * this.m21 + f12 * this.m31;
        float f27 = f9 * this.m02 + f10 * this.m12 + f11 * this.m22 + f12 * this.m32;
        float f28 = f9 * this.m03 + f10 * this.m13 + f11 * this.m23 + f12 * this.m33;
        float f29 = f13 * this.m00 + f14 * this.m10 + f15 * this.m20 + f16 * this.m30;
        float f30 = f13 * this.m01 + f14 * this.m11 + f15 * this.m21 + f16 * this.m31;
        float f31 = f13 * this.m02 + f14 * this.m12 + f15 * this.m22 + f16 * this.m32;
        float f32 = f13 * this.m03 + f14 * this.m13 + f15 * this.m23 + f16 * this.m33;
        this.m00 = f17;
        this.m01 = f18;
        this.m02 = f19;
        this.m03 = f20;
        this.m10 = f21;
        this.m11 = f22;
        this.m12 = f23;
        this.m13 = f24;
        this.m20 = f25;
        this.m21 = f26;
        this.m22 = f27;
        this.m23 = f28;
        this.m30 = f29;
        this.m31 = f30;
        this.m32 = f31;
        this.m33 = f32;
    }

    public final boolean invApply(PMatrix pMatrix) {
        PMatrix pMatrix2 = new PMatrix(pMatrix);
        PMatrix pMatrix3 = pMatrix2.invert();
        if (pMatrix3 == null) {
            return false;
        }
        this.preApply(pMatrix3);
        return true;
    }

    public final boolean invApply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        PMatrix pMatrix = new PMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        PMatrix pMatrix2 = pMatrix.invert();
        if (pMatrix2 == null) {
            return false;
        }
        this.preApply(pMatrix2);
        return true;
    }

    public final void apply(PMatrix pMatrix) {
        this.apply(pMatrix.m00, pMatrix.m01, pMatrix.m02, pMatrix.m03, pMatrix.m10, pMatrix.m11, pMatrix.m12, pMatrix.m13, pMatrix.m20, pMatrix.m21, pMatrix.m22, pMatrix.m23, pMatrix.m30, pMatrix.m31, pMatrix.m32, pMatrix.m33);
    }

    public final void apply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        float f17 = this.m00 * f + this.m01 * f5 + this.m02 * f9 + this.m03 * f13;
        float f18 = this.m00 * f2 + this.m01 * f6 + this.m02 * f10 + this.m03 * f14;
        float f19 = this.m00 * f3 + this.m01 * f7 + this.m02 * f11 + this.m03 * f15;
        float f20 = this.m00 * f4 + this.m01 * f8 + this.m02 * f12 + this.m03 * f16;
        float f21 = this.m10 * f + this.m11 * f5 + this.m12 * f9 + this.m13 * f13;
        float f22 = this.m10 * f2 + this.m11 * f6 + this.m12 * f10 + this.m13 * f14;
        float f23 = this.m10 * f3 + this.m11 * f7 + this.m12 * f11 + this.m13 * f15;
        float f24 = this.m10 * f4 + this.m11 * f8 + this.m12 * f12 + this.m13 * f16;
        float f25 = this.m20 * f + this.m21 * f5 + this.m22 * f9 + this.m23 * f13;
        float f26 = this.m20 * f2 + this.m21 * f6 + this.m22 * f10 + this.m23 * f14;
        float f27 = this.m20 * f3 + this.m21 * f7 + this.m22 * f11 + this.m23 * f15;
        float f28 = this.m20 * f4 + this.m21 * f8 + this.m22 * f12 + this.m23 * f16;
        float f29 = this.m30 * f + this.m31 * f5 + this.m32 * f9 + this.m33 * f13;
        float f30 = this.m30 * f2 + this.m31 * f6 + this.m32 * f10 + this.m33 * f14;
        float f31 = this.m30 * f3 + this.m31 * f7 + this.m32 * f11 + this.m33 * f15;
        float f32 = this.m30 * f4 + this.m31 * f8 + this.m32 * f12 + this.m33 * f16;
        this.m00 = f17;
        this.m01 = f18;
        this.m02 = f19;
        this.m03 = f20;
        this.m10 = f21;
        this.m11 = f22;
        this.m12 = f23;
        this.m13 = f24;
        this.m20 = f25;
        this.m21 = f26;
        this.m22 = f27;
        this.m23 = f28;
        this.m30 = f29;
        this.m31 = f30;
        this.m32 = f31;
        this.m33 = f32;
    }

    public final void mult3(float[] fArray, float[] fArray2) {
        float f = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02 * fArray[2] + this.m03;
        float f2 = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12 * fArray[2] + this.m13;
        float f3 = this.m20 * fArray[0] + this.m21 * fArray[1] + this.m22 * fArray[2] + this.m23;
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
    }

    public final void mult(float[] fArray, float[] fArray2) {
        float f = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02 * fArray[2] + this.m03 * fArray[3];
        float f2 = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12 * fArray[2] + this.m13 * fArray[3];
        float f3 = this.m20 * fArray[0] + this.m21 * fArray[1] + this.m22 * fArray[2] + this.m23 * fArray[3];
        float f4 = this.m30 * fArray[0] + this.m31 * fArray[1] + this.m32 * fArray[2] + this.m33 * fArray[3];
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = f4;
    }

    public final float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    private final float determinant3x3(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return f * (f5 * f9 - f6 * f8) + f2 * (f6 * f7 - f4 * f9) + f3 * (f4 * f8 - f5 * f7);
    }

    public final PMatrix transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m03;
        this.m03 = this.m30;
        this.m30 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        f = this.m13;
        this.m13 = this.m31;
        this.m31 = f;
        f = this.m23;
        this.m23 = this.m32;
        this.m32 = f;
        return this;
    }

    public final PMatrix invert() {
        float f = this.determinant();
        if (f != 0.0f) {
            float f2 = 1.0f / f;
            float f3 = this.determinant3x3(this.m11, this.m12, this.m13, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float f4 = -this.determinant3x3(this.m10, this.m12, this.m13, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float f5 = this.determinant3x3(this.m10, this.m11, this.m13, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float f6 = -this.determinant3x3(this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float f7 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float f8 = this.determinant3x3(this.m00, this.m02, this.m03, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float f9 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float f10 = this.determinant3x3(this.m00, this.m01, this.m02, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float f11 = this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m31, this.m32, this.m33);
            float f12 = -this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m30, this.m32, this.m33);
            float f13 = this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m30, this.m31, this.m33);
            float f14 = -this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m30, this.m31, this.m32);
            float f15 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
            float f16 = this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
            float f17 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
            float f18 = this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
            this.m00 = f3 * f2;
            this.m11 = f8 * f2;
            this.m22 = f13 * f2;
            this.m33 = f18 * f2;
            this.m01 = f7 * f2;
            this.m10 = f4 * f2;
            this.m20 = f5 * f2;
            this.m02 = f11 * f2;
            this.m12 = f12 * f2;
            this.m21 = f9 * f2;
            this.m03 = f15 * f2;
            this.m30 = f6 * f2;
            this.m13 = f16 * f2;
            this.m31 = f10 * f2;
            this.m32 = f14 * f2;
            this.m23 = f17 * f2;
            return this;
        }
        return null;
    }

    public final void print() {
        int n = (int)Math.abs(this.max(this.max(this.max(this.max(this.abs(this.m00), this.abs(this.m01)), this.max(this.abs(this.m02), this.abs(this.m03))), this.max(this.max(this.abs(this.m10), this.abs(this.m11)), this.max(this.abs(this.m12), this.abs(this.m13)))), this.max(this.max(this.max(this.abs(this.m20), this.abs(this.m21)), this.max(this.abs(this.m22), this.abs(this.m23))), this.max(this.max(this.abs(this.m30), this.abs(this.m31)), this.max(this.abs(this.m32), this.abs(this.m33))))));
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            n = 1000000;
        }
        int n2 = 1;
        while ((n /= 10) != 0) {
            ++n2;
        }
        System.out.println(PApplet.nfs(this.m00, n2, 4) + ' ' + PApplet.nfs(this.m01, n2, 4) + ' ' + PApplet.nfs(this.m02, n2, 4) + ' ' + PApplet.nfs(this.m03, n2, 4));
        System.out.println(PApplet.nfs(this.m10, n2, 4) + ' ' + PApplet.nfs(this.m11, n2, 4) + ' ' + PApplet.nfs(this.m12, n2, 4) + ' ' + PApplet.nfs(this.m13, n2, 4));
        System.out.println(PApplet.nfs(this.m20, n2, 4) + ' ' + PApplet.nfs(this.m21, n2, 4) + ' ' + PApplet.nfs(this.m22, n2, 4) + ' ' + PApplet.nfs(this.m23, n2, 4));
        System.out.println(PApplet.nfs(this.m30, n2, 4) + ' ' + PApplet.nfs(this.m31, n2, 4) + ' ' + PApplet.nfs(this.m32, n2, 4) + ' ' + PApplet.nfs(this.m33, n2, 4));
        System.out.println();
    }

    private final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    private final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    private final float sin(float f) {
        return (float)Math.sin(f);
    }

    private final float cos(float f) {
        return (float)Math.cos(f);
    }

    private final /* synthetic */ void this() {
        this.stackPointer = 0;
    }

    public PMatrix() {
        this.this();
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.maxStackDepth = 0;
    }

    public PMatrix(int n) {
        this.this();
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.stack = new float[n][16];
        this.maxStackDepth = n;
    }

    public PMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.this();
        this.set(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.maxStackDepth = 0;
    }

    public PMatrix(PMatrix pMatrix) {
        this.this();
        this.set(pMatrix);
        this.maxStackDepth = pMatrix.maxStackDepth;
        this.stack = new float[this.maxStackDepth][16];
    }
}

