/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics3;
import processing.core.PImage;

public class PTriangle
implements PConstants {
    static final int R_GOURAUD = 1;
    static final int R_TEXTURE8 = 2;
    static final int R_TEXTURE24 = 4;
    static final int R_TEXTURE32 = 8;
    static final int R_ALPHA = 16;
    private int[] m_pixels;
    private int[] m_texture;
    private int[] m_stencil;
    private float[] m_zbuffer;
    private int SCREEN_WIDTH;
    private int SCREEN_HEIGHT;
    private int SCREEN_WIDTH1;
    private int SCREEN_HEIGHT1;
    private int TEX_WIDTH;
    private int TEX_HEIGHT;
    private float F_TEX_WIDTH;
    private float F_TEX_HEIGHT;
    public boolean INTERPOLATE_UV;
    public boolean INTERPOLATE_RGB;
    public boolean INTERPOLATE_ALPHA;
    private float[] x_array = new float[3];
    private float[] y_array = new float[3];
    private float[] z_array = new float[3];
    private float[] u_array = new float[3];
    private float[] v_array = new float[3];
    private float[] r_array = new float[3];
    private float[] g_array = new float[3];
    private float[] b_array = new float[3];
    private float[] a_array = new float[3];
    private int o0;
    private int o1;
    private int o2;
    private float r0;
    private float r1;
    private float r2;
    private float g0;
    private float g1;
    private float g2;
    private float b0;
    private float b1;
    private float b2;
    private float a0;
    private float a1;
    private float a2;
    private float u0;
    private float u1;
    private float u2;
    private float v0;
    private float v1;
    private float v2;
    private float dx0;
    private float dx1;
    private float dx2;
    private float dy0;
    private float dy1;
    private float dy2;
    private float dz0;
    private float dz1;
    private float dz2;
    private float du0;
    private float du1;
    private float du2;
    private float dv0;
    private float dv1;
    private float dv2;
    private float dr0;
    private float dr1;
    private float dr2;
    private float dg0;
    private float dg1;
    private float dg2;
    private float db0;
    private float db1;
    private float db2;
    private float da0;
    private float da1;
    private float da2;
    private float uleft;
    private float vleft;
    private float uleftadd;
    private float vleftadd;
    private float xleft;
    private float xrght;
    private float xadd1;
    private float xadd2;
    private float zleft;
    private float zleftadd;
    private float rleft;
    private float gleft;
    private float bleft;
    private float aleft;
    private float rleftadd;
    private float gleftadd;
    private float bleftadd;
    private float aleftadd;
    private float dta;
    private float dta2;
    private float temp;
    private float width;
    private int iuadd;
    private int ivadd;
    private int iradd;
    private int igadd;
    private int ibadd;
    private int iaadd;
    private float izadd;
    private int m_fill;
    public int m_drawFlags;
    private int m_index;
    private PGraphics3 parent;
    private boolean noDepthTest;
    private boolean m_culling;
    private boolean m_singleRight;
    private boolean m_bilinear;

    public void reset() {
        this.SCREEN_WIDTH = this.parent.width;
        this.SCREEN_HEIGHT = this.parent.height;
        this.SCREEN_WIDTH1 = this.SCREEN_WIDTH - 1;
        this.SCREEN_HEIGHT1 = this.SCREEN_HEIGHT - 1;
        this.m_pixels = this.parent.pixels;
        this.m_stencil = this.parent.stencil;
        this.m_zbuffer = this.parent.zbuffer;
        this.noDepthTest = this.parent.hints[5];
        this.INTERPOLATE_UV = false;
        this.INTERPOLATE_RGB = false;
        this.INTERPOLATE_ALPHA = false;
        this.m_texture = null;
        this.m_drawFlags = 0;
    }

    public void setCulling(boolean bl) {
        this.m_culling = bl;
    }

    public void setVertices(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.x_array[0] = f;
        this.x_array[1] = f4;
        this.x_array[2] = f7;
        this.y_array[0] = f2;
        this.y_array[1] = f5;
        this.y_array[2] = f8;
        this.z_array[0] = f3;
        this.z_array[1] = f6;
        this.z_array[2] = f9;
    }

    public void setUV(float f, float f2, float f3, float f4, float f5, float f6) {
        this.u_array[0] = (f * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.u_array[1] = (f3 * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.u_array[2] = (f5 * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.v_array[0] = (f2 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
        this.v_array[1] = (f4 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
        this.v_array[2] = (f6 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
    }

    public void setIntensities(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (f4 != 1.0f || f8 != 1.0f || f12 != 1.0f) {
            this.INTERPOLATE_ALPHA = true;
            this.a_array[0] = (f4 * 253.0f + 1.0f) * 65536.0f;
            this.a_array[1] = (f8 * 253.0f + 1.0f) * 65536.0f;
            this.a_array[2] = (f12 * 253.0f + 1.0f) * 65536.0f;
            this.m_drawFlags |= 0x10;
        } else {
            this.INTERPOLATE_ALPHA = false;
            this.m_drawFlags &= 0xFFFFFFEF;
        }
        if (f != f5 || f5 != f9) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f2 != f6 || f6 != f10) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f3 != f7 || f7 != f11) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else {
            this.m_drawFlags &= 0xFFFFFFFE;
        }
        this.r_array[0] = (f * 253.0f + 1.0f) * 65536.0f;
        this.r_array[1] = (f5 * 253.0f + 1.0f) * 65536.0f;
        this.r_array[2] = (f9 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[0] = (f2 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[1] = (f6 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[2] = (f10 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[0] = (f3 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[1] = (f7 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[2] = (f11 * 253.0f + 1.0f) * 65536.0f;
        this.m_fill = (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
    }

    public void setTexture(PImage pImage) {
        this.m_texture = pImage.pixels;
        this.TEX_WIDTH = pImage.width;
        this.TEX_HEIGHT = pImage.height;
        this.F_TEX_WIDTH = this.TEX_WIDTH - 1;
        this.F_TEX_HEIGHT = this.TEX_HEIGHT - 1;
        this.INTERPOLATE_UV = true;
        if (pImage.format == 2) {
            this.m_drawFlags |= 8;
        } else if (pImage.format == 1) {
            this.m_drawFlags |= 4;
        } else if (pImage.format == 4) {
            this.m_drawFlags |= 2;
        }
        this.m_bilinear = this.parent.smooth;
    }

    public void setUV(float[] fArray, float[] fArray2) {
        if (this.m_bilinear) {
            this.u_array[0] = fArray[0] * this.F_TEX_WIDTH * 65500.0f;
            this.u_array[1] = fArray[1] * this.F_TEX_WIDTH * 65500.0f;
            this.u_array[2] = fArray[2] * this.F_TEX_WIDTH * 65500.0f;
            this.v_array[0] = fArray2[0] * this.F_TEX_HEIGHT * 65500.0f;
            this.v_array[1] = fArray2[1] * this.F_TEX_HEIGHT * 65500.0f;
            this.v_array[2] = fArray2[2] * this.F_TEX_HEIGHT * 65500.0f;
        } else {
            this.u_array[0] = fArray[0] * (float)this.TEX_WIDTH * 65500.0f;
            this.u_array[1] = fArray[1] * (float)this.TEX_WIDTH * 65500.0f;
            this.u_array[2] = fArray[2] * (float)this.TEX_WIDTH * 65500.0f;
            this.v_array[0] = fArray2[0] * (float)this.TEX_HEIGHT * 65500.0f;
            this.v_array[1] = fArray2[1] * (float)this.TEX_HEIGHT * 65500.0f;
            this.v_array[2] = fArray2[2] * (float)this.TEX_HEIGHT * 65500.0f;
        }
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public void render() {
        this.draw();
    }

    private final void draw() {
        int n;
        float f;
        float f2 = this.y_array[0];
        float f3 = this.y_array[1];
        float f4 = this.y_array[2];
        if (this.m_culling && (this.x_array[2] - (f = this.x_array[0])) * (f3 - f2) < (this.x_array[1] - f) * (f4 - f2)) {
            return;
        }
        if (f2 < f3) {
            if (f4 < f3) {
                if (f4 < f2) {
                    this.o0 = 2;
                    this.o1 = 0;
                    this.o2 = 1;
                } else {
                    this.o0 = 0;
                    this.o1 = 2;
                    this.o2 = 1;
                }
            } else {
                this.o0 = 0;
                this.o1 = 1;
                this.o2 = 2;
            }
        } else if (f4 > f3) {
            if (f4 < f2) {
                this.o0 = 1;
                this.o1 = 2;
                this.o2 = 0;
            } else {
                this.o0 = 1;
                this.o1 = 0;
                this.o2 = 2;
            }
        } else {
            this.o0 = 2;
            this.o1 = 1;
            this.o2 = 0;
        }
        f2 = this.y_array[this.o0];
        int n2 = (int)(f2 + 0.5f);
        if (n2 > this.SCREEN_HEIGHT) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (int)((f4 = this.y_array[this.o2]) + 0.5f)) < 0) {
            return;
        }
        if (n > this.SCREEN_HEIGHT) {
            n = this.SCREEN_HEIGHT;
        }
        if (n > n2) {
            f = this.x_array[this.o0];
            float f5 = this.x_array[this.o1];
            float f6 = this.x_array[this.o2];
            f3 = this.y_array[this.o1];
            int n3 = (int)(f3 + 0.5f);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > this.SCREEN_HEIGHT) {
                n3 = this.SCREEN_HEIGHT;
            }
            this.dx2 = f6 - f;
            this.dy0 = f3 - f2;
            this.dy2 = f4 - f2;
            this.xadd2 = this.dx2 / this.dy2;
            this.temp = this.dy0 / this.dy2;
            this.width = this.temp * this.dx2 + f - f5;
            if (this.INTERPOLATE_ALPHA) {
                this.a0 = this.a_array[this.o0];
                this.a1 = this.a_array[this.o1];
                this.a2 = this.a_array[this.o2];
                this.da0 = this.a1 - this.a0;
                this.da2 = this.a2 - this.a0;
                this.iaadd = (int)((this.temp * this.da2 - this.da0) / this.width);
            }
            if (this.INTERPOLATE_RGB) {
                this.r0 = this.r_array[this.o0];
                this.r1 = this.r_array[this.o1];
                this.r2 = this.r_array[this.o2];
                this.g0 = this.g_array[this.o0];
                this.g1 = this.g_array[this.o1];
                this.g2 = this.g_array[this.o2];
                this.b0 = this.b_array[this.o0];
                this.b1 = this.b_array[this.o1];
                this.b2 = this.b_array[this.o2];
                this.dr0 = this.r1 - this.r0;
                this.dg0 = this.g1 - this.g0;
                this.db0 = this.b1 - this.b0;
                this.dr2 = this.r2 - this.r0;
                this.dg2 = this.g2 - this.g0;
                this.db2 = this.b2 - this.b0;
                this.iradd = (int)((this.temp * this.dr2 - this.dr0) / this.width);
                this.igadd = (int)((this.temp * this.dg2 - this.dg0) / this.width);
                this.ibadd = (int)((this.temp * this.db2 - this.db0) / this.width);
            }
            if (this.INTERPOLATE_UV) {
                this.u0 = this.u_array[this.o0];
                this.u1 = this.u_array[this.o1];
                this.u2 = this.u_array[this.o2];
                this.v0 = this.v_array[this.o0];
                this.v1 = this.v_array[this.o1];
                this.v2 = this.v_array[this.o2];
                this.du0 = this.u1 - this.u0;
                this.dv0 = this.v1 - this.v0;
                this.du2 = this.u2 - this.u0;
                this.dv2 = this.v2 - this.v0;
                this.iuadd = (int)((this.temp * this.du2 - this.du0) / this.width);
                this.ivadd = (int)((this.temp * this.dv2 - this.dv0) / this.width);
            }
            float f7 = this.z_array[this.o0];
            float f8 = this.z_array[this.o1];
            float f9 = this.z_array[this.o2];
            this.dz0 = f8 - f7;
            this.dz2 = f9 - f7;
            this.izadd = (this.temp * this.dz2 - this.dz0) / this.width;
            if (n3 > n2) {
                this.dta = (float)n2 + 0.5f - f2;
                this.xadd1 = (f5 - f) / this.dy0;
                if (this.xadd2 > this.xadd1) {
                    this.xleft = f + this.dta * this.xadd1;
                    this.xrght = f + this.dta * this.xadd2;
                    this.zleftadd = this.dz0 / this.dy0;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du0 / this.dy0;
                        this.vleftadd = this.dv0 / this.dy0;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr0 / this.dy0;
                        this.gleftadd = this.dg0 / this.dy0;
                        this.bleftadd = this.db0 / this.dy0;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da0 / this.dy0;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                        if (this.m_drawFlags == 16) {
                            this.drawsegment_plain_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 17) {
                            this.drawsegment_gouraud_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 18) {
                            this.drawsegment_texture8_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 20) {
                            this.drawsegment_texture24_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 24) {
                            this.drawsegment_texture32_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 19) {
                            this.drawsegment_gouraud_texture8_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 21) {
                            this.drawsegment_gouraud_texture24_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 25) {
                            this.drawsegment_gouraud_texture32_alpha(this.xadd1, this.xadd2, n2, n3);
                        }
                    } else if (this.m_drawFlags == 0) {
                        this.drawsegment_plain(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 1) {
                        this.drawsegment_gouraud(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 2) {
                        this.drawsegment_texture8(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 4) {
                        this.drawsegment_texture24(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 8) {
                        this.drawsegment_texture32(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 3) {
                        this.drawsegment_gouraud_texture8(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 5) {
                        this.drawsegment_gouraud_texture24(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 9) {
                        this.drawsegment_gouraud_texture32(this.xadd1, this.xadd2, n2, n3);
                    }
                    this.m_singleRight = true;
                } else {
                    this.xleft = f + this.dta * this.xadd2;
                    this.xrght = f + this.dta * this.xadd1;
                    this.zleftadd = this.dz2 / this.dy2;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du2 / this.dy2;
                        this.vleftadd = this.dv2 / this.dy2;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr2 / this.dy2;
                        this.gleftadd = this.dg2 / this.dy2;
                        this.bleftadd = this.db2 / this.dy2;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da2 / this.dy2;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                        if (this.m_drawFlags == 16) {
                            this.drawsegment_plain_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 17) {
                            this.drawsegment_gouraud_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 18) {
                            this.drawsegment_texture8_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 20) {
                            this.drawsegment_texture24_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 24) {
                            this.drawsegment_texture32_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 19) {
                            this.drawsegment_gouraud_texture8_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 21) {
                            this.drawsegment_gouraud_texture24_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 25) {
                            this.drawsegment_gouraud_texture32_alpha(this.xadd2, this.xadd1, n2, n3);
                        }
                    } else if (this.m_drawFlags == 0) {
                        this.drawsegment_plain(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 1) {
                        this.drawsegment_gouraud(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 2) {
                        this.drawsegment_texture8(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 4) {
                        this.drawsegment_texture24(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 8) {
                        this.drawsegment_texture32(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 3) {
                        this.drawsegment_gouraud_texture8(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 5) {
                        this.drawsegment_gouraud_texture24(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 9) {
                        this.drawsegment_gouraud_texture32(this.xadd2, this.xadd1, n2, n3);
                    }
                    this.m_singleRight = false;
                }
                if (n == n3) {
                    return;
                }
                this.dy1 = f4 - f3;
                this.xadd1 = (f6 - f5) / this.dy1;
            } else {
                this.dy1 = f4 - f3;
                this.xadd1 = (f6 - f5) / this.dy1;
                if (this.xadd2 < this.xadd1) {
                    this.xrght = ((float)n3 + 0.5f - f2) * this.xadd2 + f;
                    this.m_singleRight = true;
                } else {
                    this.dta = (float)n3 + 0.5f - f2;
                    this.xleft = this.dta * this.xadd2 + f;
                    this.zleftadd = this.dz2 / this.dy2;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du2 / this.dy2;
                        this.vleftadd = this.dv2 / this.dy2;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr2 / this.dy2;
                        this.gleftadd = this.dg2 / this.dy2;
                        this.bleftadd = this.db2 / this.dy2;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da2 / this.dy2;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                    }
                    this.m_singleRight = false;
                }
            }
            if (this.m_singleRight) {
                this.dta = (float)n3 + 0.5f - f3;
                this.xleft = this.dta * this.xadd1 + f5;
                this.zleftadd = (f9 - f8) / this.dy1;
                this.zleft = this.dta * this.zleftadd + f8;
                if (this.INTERPOLATE_UV) {
                    this.uleftadd = (this.u2 - this.u1) / this.dy1;
                    this.vleftadd = (this.v2 - this.v1) / this.dy1;
                    this.uleft = this.dta * this.uleftadd + this.u1;
                    this.vleft = this.dta * this.vleftadd + this.v1;
                }
                if (this.INTERPOLATE_RGB) {
                    this.rleftadd = (this.r2 - this.r1) / this.dy1;
                    this.gleftadd = (this.g2 - this.g1) / this.dy1;
                    this.bleftadd = (this.b2 - this.b1) / this.dy1;
                    this.rleft = this.dta * this.rleftadd + this.r1;
                    this.gleft = this.dta * this.gleftadd + this.g1;
                    this.bleft = this.dta * this.bleftadd + this.b1;
                }
                if (this.INTERPOLATE_ALPHA) {
                    this.aleftadd = (this.a2 - this.a1) / this.dy1;
                    this.aleft = this.dta * this.aleftadd + this.a1;
                    if (this.m_drawFlags == 16) {
                        this.drawsegment_plain_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 17) {
                        this.drawsegment_gouraud_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 18) {
                        this.drawsegment_texture8_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 20) {
                        this.drawsegment_texture24_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 24) {
                        this.drawsegment_texture32_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 19) {
                        this.drawsegment_gouraud_texture8_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 21) {
                        this.drawsegment_gouraud_texture24_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 25) {
                        this.drawsegment_gouraud_texture32_alpha(this.xadd1, this.xadd2, n3, n);
                    }
                } else if (this.m_drawFlags == 0) {
                    this.drawsegment_plain(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 1) {
                    this.drawsegment_gouraud(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 2) {
                    this.drawsegment_texture8(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 4) {
                    this.drawsegment_texture24(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 8) {
                    this.drawsegment_texture32(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 3) {
                    this.drawsegment_gouraud_texture8(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 5) {
                    this.drawsegment_gouraud_texture24(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 9) {
                    this.drawsegment_gouraud_texture32(this.xadd1, this.xadd2, n3, n);
                }
            } else {
                this.xrght = ((float)n3 + 0.5f - f3) * this.xadd1 + f5;
                if (this.INTERPOLATE_ALPHA) {
                    if (this.m_drawFlags == 16) {
                        this.drawsegment_plain_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 17) {
                        this.drawsegment_gouraud_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 18) {
                        this.drawsegment_texture8_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 20) {
                        this.drawsegment_texture24_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 24) {
                        this.drawsegment_texture32_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 19) {
                        this.drawsegment_gouraud_texture8_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 21) {
                        this.drawsegment_gouraud_texture24_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 25) {
                        this.drawsegment_gouraud_texture32_alpha(this.xadd2, this.xadd1, n3, n);
                    }
                } else if (this.m_drawFlags == 0) {
                    this.drawsegment_plain(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 1) {
                    this.drawsegment_gouraud(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 2) {
                    this.drawsegment_texture8(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 4) {
                    this.drawsegment_texture24(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 8) {
                    this.drawsegment_texture32(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 3) {
                    this.drawsegment_gouraud_texture8(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 5) {
                    this.drawsegment_gouraud_texture24(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 9) {
                    this.drawsegment_gouraud_texture32(this.xadd2, this.xadd1, n3, n);
                }
            }
        }
    }

    private final void drawsegment_plain(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_fill;
        int n4 = this.m_index;
        while (n < n2) {
            int n5;
            int n6 = (int)(this.xleft + 0.5f);
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n5 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n5 = this.SCREEN_WIDTH;
            }
            float f3 = (float)n6 + 0.5f - this.xleft;
            float f4 = this.izadd * f3 + this.zleft;
            n6 += n;
            n5 += n;
            while (n6 < n5) {
                if (this.noDepthTest || f4 <= this.m_zbuffer[n6]) {
                    this.m_zbuffer[n6] = f4;
                    this.m_pixels[n6] = n3;
                    this.m_stencil[n6] = n4;
                }
                f4 += this.izadd;
                ++n6;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_plain_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_fill & 0xFF0000;
        int n4 = this.m_fill & 0xFF00;
        int n5 = this.m_fill & 0xFF;
        int n6 = this.m_index;
        float f3 = this.iaadd;
        while (n < n2) {
            int n7;
            int n8 = (int)(this.xleft + 0.5f);
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n7 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n7 = this.SCREEN_WIDTH;
            }
            float f4 = (float)n8 + 0.5f - this.xleft;
            float f5 = this.izadd * f4 + this.zleft;
            int n9 = (int)(f3 * f4 + this.aleft);
            n8 += n;
            n7 += n;
            while (n8 < n7) {
                if (this.noDepthTest || f5 <= this.m_zbuffer[n8]) {
                    int n10 = n9 >> 16;
                    int n11 = this.m_pixels[n8];
                    int n12 = n11 & 0xFF00;
                    int n13 = n11 & 0xFF;
                    n11 &= 0xFF0000;
                    n11 += (n3 - n11) * n10 >> 8;
                    n12 += (n4 - n12) * n10 >> 8;
                    n13 += (n5 - n13) * n10 >> 8;
                    this.m_pixels[n8] = n11 & 0xFF0000 | n12 & 0xFF00 | n13 & 0xFF;
                    this.m_stencil[n8] = n6;
                }
                f5 += this.izadd;
                n9 += this.iaadd;
                ++n8;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud(float f, float f2, int n, int n2) {
        float f3 = this.iradd;
        float f4 = this.igadd;
        float f5 = this.ibadd;
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f6 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f6 + this.rleft);
            int n7 = (int)(f4 * f6 + this.gleft);
            int n8 = (int)(f5 * f6 + this.bleft);
            float f7 = this.izadd * f6 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                if (this.noDepthTest || f7 <= this.m_zbuffer[n5]) {
                    this.m_zbuffer[n5] = f7;
                    this.m_pixels[n5] = n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16;
                    this.m_stencil[n5] = n3;
                }
                n6 += this.iradd;
                n7 += this.igadd;
                n8 += this.ibadd;
                f7 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iradd;
        float f4 = this.igadd;
        float f5 = this.ibadd;
        float f6 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f7 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f7 + this.rleft);
            int n7 = (int)(f4 * f7 + this.gleft);
            int n8 = (int)(f5 * f7 + this.bleft);
            int n9 = (int)(f6 * f7 + this.aleft);
            float f8 = this.izadd * f7 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                if (this.noDepthTest || f8 <= this.m_zbuffer[n5]) {
                    int n10 = n6 & 0xFF0000;
                    int n11 = n7 >> 8 & 0xFF00;
                    int n12 = n8 >> 16;
                    int n13 = this.m_pixels[n5];
                    int n14 = n13 & 0xFF0000;
                    int n15 = n13 & 0xFF00;
                    int n16 = n9 >> 16;
                    this.m_pixels[n5] = n14 + ((n10 - n14) * n16 >> 8) & 0xFF0000 | n15 + ((n11 - n15) * n16 >> 8) & 0xFF00 | (n13 &= 0xFF) + ((n12 - n13) * n16 >> 8) & 0xFF;
                    this.m_stencil[n5] = n3;
                }
                n6 += this.iradd;
                n7 += this.igadd;
                n8 += this.ibadd;
                n9 += this.iaadd;
                f8 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_texture8(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        int n4 = this.m_fill & 0xFF0000;
        int n5 = this.m_fill & 0xFF00;
        int n6 = this.m_fill & 0xFF;
        while (n < n2) {
            int n7;
            int n8 = (int)(this.xleft + 0.5f);
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n7 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n7 = this.SCREEN_WIDTH;
            }
            float f5 = (float)n8 + 0.5f - this.xleft;
            int n9 = (int)(f3 * f5 + this.uleft);
            int n10 = (int)(f4 * f5 + this.vleft);
            float f6 = this.izadd * f5 + this.zleft;
            n8 += n;
            n7 += n;
            while (n8 < n7) {
                try {
                    if (this.noDepthTest || f6 <= this.m_zbuffer[n8]) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        if (this.m_bilinear) {
                            n14 = (n10 >> 16) * this.TEX_WIDTH + (n9 >> 16);
                            n13 = n9 & (char)-1;
                            n12 = this.m_texture[n14] & 0xFF;
                            n11 = this.m_texture[n14 + 1] & 0xFF;
                            int n15 = this.m_texture[n14 += this.TEX_WIDTH] & 0xFF;
                            int n16 = this.m_texture[n14 + 1] & 0xFF;
                            n12 += (n11 - n12) * n13 >> 16;
                            n15 += (n16 - n15) * n13 >> 16;
                            n12 += (n15 - n12) * (n10 & (char)-1) >> 16;
                        } else {
                            n12 = this.m_texture[(n10 >> 16) * this.TEX_WIDTH + (n9 >> 16)] & 0xFF;
                        }
                        n14 = this.m_pixels[n8];
                        n13 = n14 & 0xFF00;
                        n11 = n14 & 0xFF;
                        this.m_pixels[n8] = (n14 &= 0xFF0000) + ((n4 - n14) * n12 >> 8) & 0xFF0000 | n13 + ((n5 - n13) * n12 >> 8) & 0xFF00 | n11 + ((n6 - n11) * n12 >> 8) & 0xFF;
                        this.m_stencil[n8] = n3;
                    }
                }
                catch (Exception exception) {}
                n9 += this.iuadd;
                n10 += this.ivadd;
                f6 += this.izadd;
                ++n8;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_texture8_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iaadd;
        int n4 = this.m_fill & 0xFF0000;
        int n5 = this.m_fill & 0xFF00;
        int n6 = this.m_fill & 0xFF;
        while (n < n2) {
            int n7;
            int n8 = (int)(this.xleft + 0.5f);
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n7 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n7 = this.SCREEN_WIDTH;
            }
            float f6 = (float)n8 + 0.5f - this.xleft;
            int n9 = (int)(f3 * f6 + this.uleft);
            int n10 = (int)(f4 * f6 + this.vleft);
            int n11 = (int)(f5 * f6 + this.aleft);
            float f7 = this.izadd * f6 + this.zleft;
            n8 += n;
            n7 += n;
            while (n8 < n7) {
                try {
                    if (this.noDepthTest || f7 <= this.m_zbuffer[n8]) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        if (this.m_bilinear) {
                            n15 = (n10 >> 16) * this.TEX_WIDTH + (n9 >> 16);
                            n14 = n9 & (char)-1;
                            n13 = this.m_texture[n15] & 0xFF;
                            n12 = this.m_texture[n15 + 1] & 0xFF;
                            int n16 = this.m_texture[n15 += this.TEX_WIDTH] & 0xFF;
                            int n17 = this.m_texture[n15 + 1] & 0xFF;
                            n13 += (n12 - n13) * n14 >> 16;
                            n16 += (n17 - n16) * n14 >> 16;
                            n13 += (n16 - n13) * (n10 & (char)-1) >> 16;
                        } else {
                            n13 = this.m_texture[(n10 >> 16) * this.TEX_WIDTH + (n9 >> 16)] & 0xFF;
                        }
                        n13 = n13 * (n11 >> 16) >> 8;
                        n15 = this.m_pixels[n8];
                        n14 = n15 & 0xFF00;
                        n12 = n15 & 0xFF;
                        this.m_pixels[n8] = (n15 &= 0xFF0000) + ((n4 - n15) * n13 >> 8) & 0xFF0000 | n14 + ((n5 - n14) * n13 >> 8) & 0xFF00 | n12 + ((n6 - n12) * n13 >> 8) & 0xFF;
                        this.m_stencil[n8] = n3;
                    }
                }
                catch (Exception exception) {}
                n9 += this.iuadd;
                n10 += this.ivadd;
                f7 += this.izadd;
                n11 += this.iaadd;
                ++n8;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private final void drawsegment_texture24(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f5 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f5 + this.uleft);
            int n7 = (int)(f4 * f5 + this.vleft);
            float f6 = this.izadd * f5 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f6 <= this.m_zbuffer[n5]) {
                        this.m_zbuffer[n5] = f6;
                        if (this.m_bilinear) {
                            int n8 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            int n9 = (n6 & (char)-1) >> 9;
                            int n10 = (n7 & (char)-1) >> 9;
                            int n11 = this.m_texture[n8];
                            int n12 = this.m_texture[n8 + 1];
                            int n13 = this.m_texture[n8 += this.TEX_WIDTH];
                            int n14 = this.m_texture[n8 + 1];
                            int n15 = n11 & 0xFF0000;
                            int n16 = n13 & 0xFF0000;
                            int n17 = n15 + (((n12 & 0xFF0000) - n15) * n9 >> 7);
                            int n18 = n16 + (((n14 & 0xFF0000) - n16) * n9 >> 7);
                            int n19 = n17 + ((n18 - n17) * n10 >> 7);
                            n15 = n11 & 0xFF00;
                            n16 = n13 & 0xFF00;
                            n17 = n15 + (((n12 & 0xFF00) - n15) * n9 >> 7);
                            n18 = n16 + (((n14 & 0xFF00) - n16) * n9 >> 7);
                            int n20 = n17 + ((n18 - n17) * n10 >> 7);
                            n15 = n11 & 0xFF;
                            n16 = n13 & 0xFF;
                            n17 = n15 + (((n12 & 0xFF) - n15) * n9 >> 7);
                            n18 = n16 + (((n14 & 0xFF) - n16) * n9 >> 7);
                            int n21 = n17 + ((n18 - n17) * n10 >> 7);
                            this.m_pixels[n5] = n19 & 0xFF0000 | n20 & 0xFF00 | n21 & 0xFF;
                        } else {
                            this.m_pixels[n5] = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                        }
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                f6 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_texture24_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f6 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f6 + this.uleft);
            int n7 = (int)(f4 * f6 + this.vleft);
            int n8 = (int)(f5 * f6 + this.aleft);
            float f7 = this.izadd * f6 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f7 <= this.m_zbuffer[n5]) {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15 = n8 >> 16;
                        if (this.m_bilinear) {
                            n14 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n13 = (n6 & (char)-1) >> 9;
                            n12 = (n7 & (char)-1) >> 9;
                            n11 = this.m_texture[n14];
                            n10 = this.m_texture[n14 + 1];
                            n9 = this.m_texture[n14 += this.TEX_WIDTH];
                            int n16 = this.m_texture[n14 + 1];
                            int n17 = n11 & 0xFF0000;
                            int n18 = n9 & 0xFF0000;
                            int n19 = n17 + (((n10 & 0xFF0000) - n17) * n13 >> 7);
                            int n20 = n18 + (((n16 & 0xFF0000) - n18) * n13 >> 7);
                            int n21 = n19 + ((n20 - n19) * n12 >> 7);
                            n17 = n11 & 0xFF00;
                            n18 = n9 & 0xFF00;
                            n19 = n17 + (((n10 & 0xFF00) - n17) * n13 >> 7);
                            n20 = n18 + (((n16 & 0xFF00) - n18) * n13 >> 7);
                            int n22 = n19 + ((n20 - n19) * n12 >> 7);
                            n17 = n11 & 0xFF;
                            n18 = n9 & 0xFF;
                            n19 = n17 + (((n10 & 0xFF) - n17) * n13 >> 7);
                            n20 = n18 + (((n16 & 0xFF) - n18) * n13 >> 7);
                            int n23 = n19 + ((n20 - n19) * n12 >> 7);
                            int n24 = this.m_pixels[n5];
                            int n25 = n24 & 0xFF0000;
                            int n26 = n24 & 0xFF00;
                            this.m_pixels[n5] = n25 + ((n21 - n25) * n15 >> 8) & 0xFF0000 | n26 + ((n22 - n26) * n15 >> 8) & 0xFF00 | (n24 &= 0xFF) + ((n23 - n24) * n15 >> 8) & 0xFF;
                        } else {
                            n14 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n13 = n14 & 0xFF00;
                            n12 = n14 & 0xFF;
                            n11 = this.m_pixels[n5];
                            n10 = n11 & 0xFF0000;
                            n9 = n11 & 0xFF00;
                            this.m_pixels[n5] = n10 + (((n14 &= 0xFF0000) - n10) * n15 >> 8) & 0xFF0000 | n9 + ((n13 - n9) * n15 >> 8) & 0xFF00 | (n11 &= 0xFF) + ((n12 - n11) * n15 >> 8) & 0xFF;
                        }
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iaadd;
                f7 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private final void drawsegment_texture32(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f5 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f5 + this.uleft);
            int n7 = (int)(f4 * f5 + this.vleft);
            float f6 = this.izadd * f5 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f6 <= this.m_zbuffer[n5]) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        if (this.m_bilinear) {
                            n14 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n13 = (n6 & (char)-1) >> 9;
                            n12 = (n7 & (char)-1) >> 9;
                            n11 = this.m_texture[n14];
                            n10 = this.m_texture[n14 + 1];
                            n9 = this.m_texture[n14 += this.TEX_WIDTH];
                            n8 = this.m_texture[n14 + 1];
                            int n15 = n11 & 0xFF0000;
                            int n16 = n9 & 0xFF0000;
                            int n17 = n15 + (((n10 & 0xFF0000) - n15) * n13 >> 7);
                            int n18 = n16 + (((n8 & 0xFF0000) - n16) * n13 >> 7);
                            int n19 = n17 + ((n18 - n17) * n12 >> 7);
                            n15 = n11 & 0xFF00;
                            n16 = n9 & 0xFF00;
                            n17 = n15 + (((n10 & 0xFF00) - n15) * n13 >> 7);
                            n18 = n16 + (((n8 & 0xFF00) - n16) * n13 >> 7);
                            int n20 = n17 + ((n18 - n17) * n12 >> 7);
                            n15 = n11 & 0xFF;
                            n16 = n9 & 0xFF;
                            n17 = n15 + (((n10 & 0xFF) - n15) * n13 >> 7);
                            n18 = n16 + (((n8 & 0xFF) - n16) * n13 >> 7);
                            int n21 = n17 + ((n18 - n17) * n12 >> 7);
                            n17 = (n11 >>>= 24) + (((n10 >>> 24) - n11) * n13 >> 7);
                            n18 = (n9 >>>= 24) + (((n8 >>> 24) - n9) * n13 >> 7);
                            int n22 = n17 + ((n18 - n17) * n12 >> 7);
                            int n23 = this.m_pixels[n5];
                            int n24 = n23 & 0xFF0000;
                            int n25 = n23 & 0xFF00;
                            this.m_pixels[n5] = n24 + ((n19 - n24) * n22 >> 8) & 0xFF0000 | n25 + ((n20 - n25) * n22 >> 8) & 0xFF00 | (n23 &= 0xFF) + ((n21 - n23) * n22 >> 8) & 0xFF;
                        } else {
                            n14 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n13 = n14 >>> 24;
                            n12 = n14 & 0xFF00;
                            n11 = n14 & 0xFF;
                            n10 = this.m_pixels[n5];
                            n9 = n10 & 0xFF0000;
                            n8 = n10 & 0xFF00;
                            this.m_pixels[n5] = n9 + (((n14 &= 0xFF0000) - n9) * n13 >> 8) & 0xFF0000 | n8 + ((n12 - n8) * n13 >> 8) & 0xFF00 | (n10 &= 0xFF) + ((n11 - n10) * n13 >> 8) & 0xFF;
                        }
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                f6 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private final void drawsegment_texture32_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f6 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f6 + this.uleft);
            int n7 = (int)(f4 * f6 + this.vleft);
            int n8 = (int)(f5 * f6 + this.aleft);
            float f7 = this.izadd * f6 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f7 <= this.m_zbuffer[n5]) {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15 = n8 >> 16;
                        if (this.m_bilinear) {
                            n14 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n13 = (n6 & (char)-1) >> 9;
                            n12 = (n7 & (char)-1) >> 9;
                            n11 = this.m_texture[n14];
                            n10 = this.m_texture[n14 + 1];
                            n9 = this.m_texture[n14 += this.TEX_WIDTH];
                            int n16 = this.m_texture[n14 + 1];
                            int n17 = n11 & 0xFF0000;
                            int n18 = n9 & 0xFF0000;
                            int n19 = n17 + (((n10 & 0xFF0000) - n17) * n13 >> 7);
                            int n20 = n18 + (((n16 & 0xFF0000) - n18) * n13 >> 7);
                            int n21 = n19 + ((n20 - n19) * n12 >> 7);
                            n17 = n11 & 0xFF00;
                            n18 = n9 & 0xFF00;
                            n19 = n17 + (((n10 & 0xFF00) - n17) * n13 >> 7);
                            n20 = n18 + (((n16 & 0xFF00) - n18) * n13 >> 7);
                            int n22 = n19 + ((n20 - n19) * n12 >> 7);
                            n17 = n11 & 0xFF;
                            n18 = n9 & 0xFF;
                            n19 = n17 + (((n10 & 0xFF) - n17) * n13 >> 7);
                            n20 = n18 + (((n16 & 0xFF) - n18) * n13 >> 7);
                            int n23 = n19 + ((n20 - n19) * n12 >> 7);
                            n19 = (n11 >>>= 24) + (((n10 >>> 24) - n11) * n13 >> 7);
                            n20 = (n9 >>>= 24) + (((n16 >>> 24) - n9) * n13 >> 7);
                            n15 = n15 * (n19 + ((n20 - n19) * n12 >> 7)) >> 8;
                            int n24 = this.m_pixels[n5];
                            int n25 = n24 & 0xFF0000;
                            int n26 = n24 & 0xFF00;
                            this.m_pixels[n5] = n25 + ((n21 - n25) * n15 >> 8) & 0xFF0000 | n26 + ((n22 - n26) * n15 >> 8) & 0xFF00 | (n24 &= 0xFF) + ((n23 - n24) * n15 >> 8) & 0xFF;
                        } else {
                            n14 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n15 = n15 * (n14 >>> 24) >> 8;
                            n13 = n14 & 0xFF00;
                            n12 = n14 & 0xFF;
                            n11 = this.m_pixels[n5];
                            n10 = n11 & 0xFF0000;
                            n9 = n11 & 0xFF00;
                            this.m_pixels[n5] = n10 + (((n14 &= 0xFF0000) - n10) * n15 >> 8) & 0xFF0000 | n9 + ((n13 - n9) * n15 >> 8) & 0xFF00 | (n11 &= 0xFF) + ((n12 - n11) * n15 >> 8) & 0xFF;
                        }
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iaadd;
                f7 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private final void drawsegment_gouraud_texture8(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f8 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f8 + this.uleft);
            int n7 = (int)(f4 * f8 + this.vleft);
            int n8 = (int)(f5 * f8 + this.rleft);
            int n9 = (int)(f6 * f8 + this.gleft);
            int n10 = (int)(f7 * f8 + this.bleft);
            float f9 = this.izadd * f8 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f9 <= this.m_zbuffer[n5]) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        if (this.m_bilinear) {
                            n16 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n15 = n6 & (char)-1;
                            n14 = this.m_texture[n16] & 0xFF;
                            n13 = this.m_texture[n16 + 1] & 0xFF;
                            n12 = this.m_texture[n16 += this.TEX_WIDTH] & 0xFF;
                            n11 = this.m_texture[n16 + 1] & 0xFF;
                            n14 += (n13 - n14) * n15 >> 16;
                            n12 += (n11 - n12) * n15 >> 16;
                            n14 += (n12 - n14) * (n7 & (char)-1) >> 16;
                        } else {
                            n14 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)] & 0xFF;
                        }
                        n16 = n8 & 0xFF0000;
                        n15 = n9 >> 8 & 0xFF00;
                        n13 = n10 >> 16;
                        n12 = this.m_pixels[n5];
                        n11 = n12 & 0xFF0000;
                        int n17 = n12 & 0xFF00;
                        this.m_pixels[n5] = n11 + ((n16 - n11) * n14 >> 8) & 0xFF0000 | n17 + ((n15 - n17) * n14 >> 8) & 0xFF00 | (n12 &= 0xFF) + ((n13 - n12) * n14 >> 8) & 0xFF;
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                f9 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_texture8_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        float f8 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f9 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f9 + this.uleft);
            int n7 = (int)(f4 * f9 + this.vleft);
            int n8 = (int)(f5 * f9 + this.rleft);
            int n9 = (int)(f6 * f9 + this.gleft);
            int n10 = (int)(f7 * f9 + this.bleft);
            int n11 = (int)(f8 * f9 + this.aleft);
            float f10 = this.izadd * f9 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f10 <= this.m_zbuffer[n5]) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        if (this.m_bilinear) {
                            n17 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n16 = n6 & (char)-1;
                            n15 = this.m_texture[n17] & 0xFF;
                            n14 = this.m_texture[n17 + 1] & 0xFF;
                            n13 = this.m_texture[n17 += this.TEX_WIDTH] & 0xFF;
                            n12 = this.m_texture[n17 + 1] & 0xFF;
                            n15 += (n14 - n15) * n16 >> 16;
                            n13 += (n12 - n13) * n16 >> 16;
                            n15 += (n13 - n15) * (n7 & (char)-1) >> 16;
                        } else {
                            n15 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)] & 0xFF;
                        }
                        n15 = n15 * (n11 >> 16) >> 8;
                        n17 = n8 & 0xFF0000;
                        n16 = n9 >> 8 & 0xFF00;
                        n14 = n10 >> 16;
                        n13 = this.m_pixels[n5];
                        n12 = n13 & 0xFF0000;
                        int n18 = n13 & 0xFF00;
                        this.m_pixels[n5] = n12 + ((n17 - n12) * n15 >> 8) & 0xFF0000 | n18 + ((n16 - n18) * n15 >> 8) & 0xFF00 | (n13 &= 0xFF) + ((n14 - n13) * n15 >> 8) & 0xFF;
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                n11 += this.iaadd;
                f10 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_texture24(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f8 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f8 + this.uleft);
            int n7 = (int)(f4 * f8 + this.vleft);
            int n8 = (int)(f5 * f8 + this.rleft);
            int n9 = (int)(f6 * f8 + this.gleft);
            int n10 = (int)(f7 * f8 + this.bleft);
            float f9 = this.izadd * f8 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f9 <= this.m_zbuffer[n5]) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        this.m_zbuffer[n5] = f9;
                        if (this.m_bilinear) {
                            n16 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n15 = (n6 & (char)-1) >> 9;
                            n14 = (n7 & (char)-1) >> 9;
                            int n17 = this.m_texture[n16];
                            int n18 = this.m_texture[n16 + 1];
                            int n19 = this.m_texture[n16 += this.TEX_WIDTH];
                            int n20 = this.m_texture[n16 + 1];
                            int n21 = n17 & 0xFF0000;
                            int n22 = n19 & 0xFF0000;
                            int n23 = n21 + (((n18 & 0xFF0000) - n21) * n15 >> 7);
                            int n24 = n22 + (((n20 & 0xFF0000) - n22) * n15 >> 7);
                            n13 = n23 + ((n24 - n23) * n14 >> 7);
                            n21 = n17 & 0xFF00;
                            n22 = n19 & 0xFF00;
                            n23 = n21 + (((n18 & 0xFF00) - n21) * n15 >> 7);
                            n24 = n22 + (((n20 & 0xFF00) - n22) * n15 >> 7);
                            n12 = n23 + ((n24 - n23) * n14 >> 7);
                            n21 = n17 & 0xFF;
                            n22 = n19 & 0xFF;
                            n23 = n21 + (((n18 & 0xFF) - n21) * n15 >> 7);
                            n24 = n22 + (((n20 & 0xFF) - n22) * n15 >> 7);
                            n11 = n23 + ((n24 - n23) * n14 >> 7);
                        } else {
                            n11 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n13 = n11 & 0xFF0000;
                            n12 = n11 & 0xFF00;
                            n11 &= 0xFF;
                        }
                        n16 = n8 >> 16;
                        n15 = n9 >> 16;
                        n14 = n10 >> 16;
                        this.m_pixels[n5] = (n13 * n16 & 0xFF000000 | n12 * n15 & 0xFF0000 | n11 * n14) >> 8;
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                f9 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_texture24_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        float f8 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f9 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f9 + this.uleft);
            int n7 = (int)(f4 * f9 + this.vleft);
            int n8 = (int)(f5 * f9 + this.rleft);
            int n9 = (int)(f6 * f9 + this.gleft);
            int n10 = (int)(f7 * f9 + this.bleft);
            int n11 = (int)(f8 * f9 + this.aleft);
            float f10 = this.izadd * f9 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f10 <= this.m_zbuffer[n5]) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18 = n11 >> 16;
                        if (this.m_bilinear) {
                            n17 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n16 = (n6 & (char)-1) >> 9;
                            n15 = (n7 & (char)-1) >> 9;
                            int n19 = this.m_texture[n17];
                            int n20 = this.m_texture[n17 + 1];
                            int n21 = this.m_texture[n17 += this.TEX_WIDTH];
                            int n22 = this.m_texture[n17 + 1];
                            int n23 = n19 & 0xFF0000;
                            int n24 = n21 & 0xFF0000;
                            int n25 = n23 + (((n20 & 0xFF0000) - n23) * n16 >> 7);
                            int n26 = n24 + (((n22 & 0xFF0000) - n24) * n16 >> 7);
                            n14 = n25 + ((n26 - n25) * n15 >> 7) >> 16;
                            n23 = n19 & 0xFF00;
                            n24 = n21 & 0xFF00;
                            n25 = n23 + (((n20 & 0xFF00) - n23) * n16 >> 7);
                            n26 = n24 + (((n22 & 0xFF00) - n24) * n16 >> 7);
                            n13 = n25 + ((n26 - n25) * n15 >> 7) >> 8;
                            n23 = n19 & 0xFF;
                            n24 = n21 & 0xFF;
                            n25 = n23 + (((n20 & 0xFF) - n23) * n16 >> 7);
                            n26 = n24 + (((n22 & 0xFF) - n24) * n16 >> 7);
                            n12 = n25 + ((n26 - n25) * n15 >> 7);
                        } else {
                            n12 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n14 = (n12 & 0xFF0000) >> 16;
                            n13 = (n12 & 0xFF00) >> 8;
                            n12 &= 0xFF;
                        }
                        n14 = n14 * n8 >>> 8;
                        n13 = n13 * n9 >>> 16;
                        n12 = n12 * n10 >>> 24;
                        n17 = this.m_pixels[n5];
                        n16 = n17 & 0xFF0000;
                        n15 = n17 & 0xFF00;
                        this.m_pixels[n5] = n16 + ((n14 - n16) * n18 >> 8) & 0xFF0000 | n15 + ((n13 - n15) * n18 >> 8) & 0xFF00 | (n17 &= 0xFF) + ((n12 - n17) * n18 >> 8) & 0xFF;
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                n11 += this.iaadd;
                f10 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_texture32(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f8 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f8 + this.uleft);
            int n7 = (int)(f4 * f8 + this.vleft);
            int n8 = (int)(f5 * f8 + this.rleft);
            int n9 = (int)(f6 * f8 + this.gleft);
            int n10 = (int)(f7 * f8 + this.bleft);
            float f9 = this.izadd * f8 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f9 <= this.m_zbuffer[n5]) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        if (this.m_bilinear) {
                            n17 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n16 = (n6 & (char)-1) >> 9;
                            n15 = (n7 & (char)-1) >> 9;
                            int n18 = this.m_texture[n17];
                            int n19 = this.m_texture[n17 + 1];
                            int n20 = this.m_texture[n17 += this.TEX_WIDTH];
                            int n21 = this.m_texture[n17 + 1];
                            int n22 = n18 & 0xFF0000;
                            int n23 = n20 & 0xFF0000;
                            int n24 = n22 + (((n19 & 0xFF0000) - n22) * n16 >> 7);
                            int n25 = n23 + (((n21 & 0xFF0000) - n23) * n16 >> 7);
                            n14 = n24 + ((n25 - n24) * n15 >> 7) >> 16;
                            n22 = n18 & 0xFF00;
                            n23 = n20 & 0xFF00;
                            n24 = n22 + (((n19 & 0xFF00) - n22) * n16 >> 7);
                            n25 = n23 + (((n21 & 0xFF00) - n23) * n16 >> 7);
                            n13 = n24 + ((n25 - n24) * n15 >> 7) >> 8;
                            n22 = n18 & 0xFF;
                            n23 = n20 & 0xFF;
                            n24 = n22 + (((n19 & 0xFF) - n22) * n16 >> 7);
                            n25 = n23 + (((n21 & 0xFF) - n23) * n16 >> 7);
                            n12 = n24 + ((n25 - n24) * n15 >> 7);
                            n24 = (n18 >>>= 24) + (((n19 >>> 24) - n18) * n16 >> 7);
                            n25 = (n20 >>>= 24) + (((n21 >>> 24) - n20) * n16 >> 7);
                            n11 = n24 + ((n25 - n24) * n15 >> 7);
                        } else {
                            n12 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n11 = n12 >>> 24;
                            n14 = (n12 & 0xFF0000) >> 16;
                            n13 = (n12 & 0xFF00) >> 8;
                            n12 &= 0xFF;
                        }
                        n14 = n14 * n8 >>> 8;
                        n13 = n13 * n9 >>> 16;
                        n12 = n12 * n10 >>> 24;
                        n17 = this.m_pixels[n5];
                        n16 = n17 & 0xFF0000;
                        n15 = n17 & 0xFF00;
                        this.m_pixels[n5] = n16 + ((n14 - n16) * n11 >> 8) & 0xFF0000 | n15 + ((n13 - n15) * n11 >> 8) & 0xFF00 | (n17 &= 0xFF) + ((n12 - n17) * n11 >> 8) & 0xFF;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                f9 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private final void drawsegment_gouraud_texture32_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        float f5 = this.iradd;
        float f6 = this.igadd;
        float f7 = this.ibadd;
        float f8 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f9 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f9 + this.uleft);
            int n7 = (int)(f4 * f9 + this.vleft);
            int n8 = (int)(f5 * f9 + this.rleft);
            int n9 = (int)(f6 * f9 + this.gleft);
            int n10 = (int)(f7 * f9 + this.bleft);
            int n11 = (int)(f8 * f9 + this.aleft);
            float f10 = this.izadd * f9 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                try {
                    if (this.noDepthTest || f10 <= this.m_zbuffer[n5]) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18 = n11 >> 16;
                        if (this.m_bilinear) {
                            n17 = (n7 >> 16) * this.TEX_WIDTH + (n6 >> 16);
                            n16 = (n6 & (char)-1) >> 9;
                            n15 = (n7 & (char)-1) >> 9;
                            int n19 = this.m_texture[n17];
                            int n20 = this.m_texture[n17 + 1];
                            int n21 = this.m_texture[n17 += this.TEX_WIDTH];
                            int n22 = this.m_texture[n17 + 1];
                            int n23 = n19 & 0xFF0000;
                            int n24 = n21 & 0xFF0000;
                            int n25 = n23 + (((n20 & 0xFF0000) - n23) * n16 >> 7);
                            int n26 = n24 + (((n22 & 0xFF0000) - n24) * n16 >> 7);
                            n14 = n25 + ((n26 - n25) * n15 >> 7) >> 16;
                            n23 = n19 & 0xFF00;
                            n24 = n21 & 0xFF00;
                            n25 = n23 + (((n20 & 0xFF00) - n23) * n16 >> 7);
                            n26 = n24 + (((n22 & 0xFF00) - n24) * n16 >> 7);
                            n13 = n25 + ((n26 - n25) * n15 >> 7) >> 8;
                            n23 = n19 & 0xFF;
                            n24 = n21 & 0xFF;
                            n25 = n23 + (((n20 & 0xFF) - n23) * n16 >> 7);
                            n26 = n24 + (((n22 & 0xFF) - n24) * n16 >> 7);
                            n12 = n25 + ((n26 - n25) * n15 >> 7);
                            n25 = (n19 >>>= 24) + (((n20 >>> 24) - n19) * n16 >> 7);
                            n26 = (n21 >>>= 24) + (((n22 >>> 24) - n21) * n16 >> 7);
                            n18 = n18 * (n25 + ((n26 - n25) * n15 >> 7)) >> 8;
                        } else {
                            n12 = this.m_texture[(n7 >> 16) * this.TEX_WIDTH + (n6 >> 16)];
                            n18 = n18 * (n12 >>> 24) >> 8;
                            n14 = (n12 & 0xFF0000) >> 16;
                            n13 = (n12 & 0xFF00) >> 8;
                            n12 &= 0xFF;
                        }
                        n14 = n14 * n8 >>> 8;
                        n13 = n13 * n9 >>> 16;
                        n12 = n12 * n10 >>> 24;
                        n17 = this.m_pixels[n5];
                        n16 = n17 & 0xFF0000;
                        n15 = n17 & 0xFF00;
                        this.m_pixels[n5] = n16 + ((n14 - n16) * n18 >> 8) & 0xFF0000 | n15 + ((n13 - n15) * n18 >> 8) & 0xFF00 | (n17 &= 0xFF) + ((n12 - n17) * n18 >> 8) & 0xFF;
                        this.m_stencil[n5] = n3;
                    }
                }
                catch (Exception exception) {}
                n6 += this.iuadd;
                n7 += this.ivadd;
                n8 += this.iradd;
                n9 += this.igadd;
                n10 += this.ibadd;
                n11 += this.iaadd;
                f10 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    public PTriangle(PGraphics3 pGraphics3) {
        this.parent = pGraphics3;
        this.reset();
    }
}

